/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.automate;

import com.sshtools.common.automate.AuthorizedKeys;
import com.sshtools.common.automate.AuthorizedKeysFileLoader;
import com.sshtools.common.automate.AuthorizedKeysFileSaver;
import com.sshtools.common.automate.AuthorizedKeysFormat;
import com.sshtools.common.automate.RemoteIdentificationException;
import com.sshtools.common.automate.RemoteIdentificationRule;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteIdentification {
    public static final int ADD_AUTHORIZEDKEY = 1;
    public static final int REMOVE_AUTHORIZEDKEY = 2;
    private String defaultName;
    private Vector rules = new Vector();
    private Class authorizedKeysFormat;
    private String defaultPath;
    protected Log log = LogFactory.getLog((Class)(class$com$sshtools$common$automate$RemoteIdentification == null ? (class$com$sshtools$common$automate$RemoteIdentification = RemoteIdentification.class$("com.sshtools.common.automate.RemoteIdentification")) : class$com$sshtools$common$automate$RemoteIdentification));
    static /* synthetic */ Class class$com$sshtools$common$automate$RemoteIdentification;

    public RemoteIdentification(String string) {
        this.defaultName = string;
    }

    protected List getRules() {
        return this.rules;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public String getName(String string) throws RemoteIdentificationException {
        RemoteIdentificationRule remoteIdentificationRule;
        boolean bl = false;
        Iterator iterator = this.rules.iterator();
        Vector<RemoteIdentificationRule> vector = new Vector<RemoteIdentificationRule>();
        Object var6_5 = null;
        while (iterator.hasNext()) {
            remoteIdentificationRule = (RemoteIdentificationRule)iterator.next();
            if (!remoteIdentificationRule.testRule(string)) continue;
            vector.add(remoteIdentificationRule);
        }
        if (vector.size() > 0) {
            iterator = vector.iterator();
            RemoteIdentificationRule remoteIdentificationRule2 = null;
            while (iterator.hasNext()) {
                remoteIdentificationRule = (RemoteIdentificationRule)iterator.next();
                if (remoteIdentificationRule2 == null) {
                    remoteIdentificationRule2 = remoteIdentificationRule;
                    continue;
                }
                if (remoteIdentificationRule.getPriority() >= remoteIdentificationRule2.getPriority()) continue;
                remoteIdentificationRule2 = remoteIdentificationRule;
            }
            if (remoteIdentificationRule2.getName() != null) {
                return remoteIdentificationRule2.getName();
            }
            return this.defaultName;
        }
        throw new RemoteIdentificationException("No rules exist to identify the remote host with ident string " + string);
    }

    protected void addRule(RemoteIdentificationRule remoteIdentificationRule) {
        this.rules.add(remoteIdentificationRule);
    }

    protected boolean testRules(String string) {
        boolean bl = false;
        Iterator iterator = this.rules.iterator();
        while (iterator.hasNext() && !bl) {
            RemoteIdentificationRule remoteIdentificationRule = (RemoteIdentificationRule)iterator.next();
            bl = remoteIdentificationRule.testRule(string);
        }
        return bl;
    }

    protected void setAuthorizedKeysFormat(Class clazz) {
        this.authorizedKeysFormat = clazz;
    }

    protected void setAuthorizedKeysDefaultPath(String string) {
        this.defaultPath = string;
    }

    public String getAuthorizedKeysDefaultPath() {
        return this.defaultPath;
    }

    public AuthorizedKeysFormat getAuthorizedKeysFormat() throws RemoteIdentificationException {
        try {
            if (this.authorizedKeysFormat != null) {
                return (AuthorizedKeysFormat)this.authorizedKeysFormat.newInstance();
            }
            throw new RemoteIdentificationException("There is no authorized keys format set for this remote id");
        }
        catch (Exception exception) {
            throw new RemoteIdentificationException("Failed to instansiate " + this.authorizedKeysFormat.getName());
        }
    }

    public boolean configureUserAccess(SshClient sshClient, String string, String string2, SshPublicKey sshPublicKey, String string3, int n) throws RemoteIdentificationException {
        Vector<SshPublicKey> vector = new Vector<SshPublicKey>();
        vector.add(sshPublicKey);
        return this.configureUserAccess(sshClient, string, string2, vector, string3, n);
    }

    public boolean configureUserAccess(SshClient sshClient, String string, String string2, List list, String string3, int n) throws RemoteIdentificationException {
        try {
            AuthorizedKeys authorizedKeys;
            Object object;
            Object object2;
            if (!sshClient.isAuthenticated()) {
                throw new RemoteIdentificationException("Connection must already be connected and authenticated");
            }
            if (string3 == null) {
                throw new RemoteIdentificationException("authorization file cannot be null");
            }
            if (n != 1 && n != 2) {
                throw new RemoteIdentificationException("Invalid configuration mode specifed in call to configureUserAccess");
            }
            final SftpClient sftpClient = sshClient.openSftpClient();
            string3.replace('\\', '/');
            final String string4 = string3.lastIndexOf("/") > 0 ? string3.substring(0, string3.lastIndexOf("/") + 1) : "";
            try {
                sftpClient.rm(string3 + ".bak");
                sftpClient.rename(string3, string3 + ".bak");
                this.log.info((Object)("Opening existing authorized keys file from " + string3 + ".bak"));
                object2 = new ByteArrayOutputStream();
                sftpClient.get(string3 + ".bak");
                object = ((ByteArrayOutputStream)object2).toByteArray();
                ((ByteArrayOutputStream)object2).close();
                this.log.info((Object)"Parsing authorized keys file");
                authorizedKeys = AuthorizedKeys.parse((byte[])object, sshClient.getServerId(), new AuthorizedKeysFileLoader(){

                    public byte[] loadFile(String string) throws IOException {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        sftpClient.get(string4 + string, (OutputStream)byteArrayOutputStream);
                        byteArrayOutputStream.close();
                        return byteArrayOutputStream.toByteArray();
                    }
                });
            }
            catch (IOException iOException) {
                authorizedKeys = new AuthorizedKeys();
            }
            catch (RemoteIdentificationException remoteIdentificationException) {
                throw new RemoteIdentificationException("Open3SP cannot identify the remote host.\nPlease email support@open3sp.org with specifying 'remote identification' in the subject and supplying the server type and the follwing data '" + sshClient.getServerId() + "'");
            }
            this.log.info((Object)"Updating authorized keys file");
            object = list.iterator();
            while (object.hasNext()) {
                object2 = (SshPublicKey)object.next();
                if (!authorizedKeys.containsKey((SshPublicKey)object2) && n == 1) {
                    authorizedKeys.addKey(string2, (SshPublicKey)object2);
                    continue;
                }
                if (!authorizedKeys.containsKey((SshPublicKey)object2) || n != 2) continue;
                authorizedKeys.removeKey((SshPublicKey)object2);
            }
            this.log.info((Object)("Verifying directory " + string4));
            sftpClient.mkdirs(string4);
            this.log.info((Object)("Writing new authorized keys file to " + string3));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(AuthorizedKeys.create(authorizedKeys, sshClient.getServerId(), new AuthorizedKeysFileSaver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void saveFile(String string, byte[] byArray) throws IOException {
                    ByteArrayInputStream byteArrayInputStream = null;
                    try {
                        try {
                            byteArrayInputStream = new ByteArrayInputStream(byArray);
                            sftpClient.put((InputStream)byteArrayInputStream, string4 + string);
                        }
                        catch (IOException iOException) {
                            RemoteIdentification.this.log.info((Object)("Error writing public key file to server" + string), (Throwable)iOException);
                            Object var6_5 = null;
                            if (byteArrayInputStream == null) return;
                            byteArrayInputStream.close();
                            return;
                        }
                        Object var6_4 = null;
                        if (byteArrayInputStream == null) return;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (byteArrayInputStream == null) throw throwable;
                        byteArrayInputStream.close();
                        throw throwable;
                    }
                    byteArrayInputStream.close();
                }
            }));
            byteArrayOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            sftpClient.put((InputStream)byteArrayInputStream, string3);
            sftpClient.quit();
            return true;
        }
        catch (IOException iOException) {
            throw new RemoteIdentificationException("Some sort of error occurred!");
        }
        catch (RemoteIdentificationException remoteIdentificationException) {
            throw new RemoteIdentificationException("SSHTools cannot identify the remote host.\nPlease email support@sshtools.com specifying 'remote identification' in the subject, supplying the server type and the following data: '" + sshClient.getServerId() + "'");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

