/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.JDBCException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Constants;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

public abstract class HibernateAccessor
implements InitializingBean {
    public static final int FLUSH_NEVER = 0;
    public static final int FLUSH_AUTO = 1;
    public static final int FLUSH_EAGER = 2;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final Constants constants = new Constants(class$org$springframework$orm$hibernate3$HibernateAccessor == null ? (class$org$springframework$orm$hibernate3$HibernateAccessor = HibernateAccessor.class$("org.springframework.orm.hibernate3.HibernateAccessor")) : class$org$springframework$orm$hibernate3$HibernateAccessor);
    private SessionFactory sessionFactory;
    private Interceptor entityInterceptor;
    private SQLExceptionTranslator jdbcExceptionTranslator;
    private int flushMode = 1;
    static /* synthetic */ Class class$org$springframework$orm$hibernate3$HibernateAccessor;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setEntityInterceptor(Interceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    public Interceptor getEntityInterceptor() {
        return this.entityInterceptor;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        if (this.jdbcExceptionTranslator == null) {
            this.jdbcExceptionTranslator = SessionFactoryUtils.newJdbcExceptionTranslator(this.getSessionFactory());
        }
        return this.jdbcExceptionTranslator;
    }

    public void setFlushModeName(String constantName) {
        this.setFlushMode(constants.asNumber(constantName).intValue());
    }

    public void setFlushMode(int flushMode) {
        this.flushMode = flushMode;
    }

    public int getFlushMode() {
        return this.flushMode;
    }

    public void afterPropertiesSet() {
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("sessionFactory is required");
        }
    }

    public void flushIfNecessary(Session session, boolean existingTransaction) throws HibernateException {
        if (this.getFlushMode() == 2 || !existingTransaction && this.getFlushMode() == 1) {
            this.logger.debug((Object)"Eagerly flushing Hibernate session");
            session.flush();
        }
    }

    public DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCException) {
            return this.convertJdbcAccessException(((JDBCException)ex).getSQLException());
        }
        return SessionFactoryUtils.convertHibernateAccessException(ex);
    }

    protected DataAccessException convertJdbcAccessException(SQLException ex) {
        return this.getJdbcExceptionTranslator().translate("Hibernate operation", null, ex);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

