/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ClassEditor
extends PropertyEditorSupport {
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText(text)) {
            try {
                this.setValue(ClassUtils.forName(text.trim()));
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Invalid class name: " + ex.getMessage());
            }
        } else {
            this.setValue(null);
        }
    }

    public String getAsText() {
        Class clazz = (Class)this.getValue();
        return clazz.isArray() ? clazz.getComponentType().getName() + "[]" : clazz.getName();
    }
}

