/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.velocity;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.ui.velocity.CommonsLoggingLogSystem;

public class VelocityEngineFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private final Map velocityProperties = new HashMap();
    private String resourceLoaderPath;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private boolean overrideLogging = true;
    static /* synthetic */ Class class$org$springframework$ui$velocity$SpringResourceLoader;

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setVelocityProperties(Properties velocityProperties) {
        this.velocityProperties.putAll(velocityProperties);
    }

    public void setVelocityPropertiesMap(Map velocityPropertiesMap) {
        this.velocityProperties.putAll(velocityPropertiesMap);
    }

    public void setResourceLoaderPath(String resourceLoaderPath) {
        this.resourceLoaderPath = resourceLoaderPath;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setOverrideLogging(boolean overrideLogging) {
        this.overrideLogging = overrideLogging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VelocityEngine createVelocityEngine() throws IOException, VelocityException {
        VelocityEngine velocityEngine = this.newVelocityEngine();
        Properties props = new Properties();
        if (this.configLocation != null) {
            this.logger.info((Object)("Loading Velocity config from [" + this.configLocation + "]"));
            InputStream is = this.configLocation.getInputStream();
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
        }
        if (!this.velocityProperties.isEmpty()) {
            props.putAll((Map<?, ?>)this.velocityProperties);
        }
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            velocityEngine.setProperty(key, props.get(key));
        }
        if (this.resourceLoaderPath != null) {
            try {
                Resource path = this.resourceLoader.getResource(this.resourceLoaderPath);
                velocityEngine.setProperty("resource.loader", (Object)"file");
                velocityEngine.setProperty("file.resource.loader.path", (Object)path.getFile().getAbsolutePath());
            }
            catch (IOException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Cannot resolve resource loader path [" + this.resourceLoaderPath + "] to File: using SpringResourceLoader"), (Throwable)ex);
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Cannot resolve resource loader path [" + this.resourceLoaderPath + "] to File: using SpringResourceLoader"));
                }
                velocityEngine.setProperty("resource.loader", (Object)"spring");
                velocityEngine.setProperty("spring.resource.loader.class", (Object)(class$org$springframework$ui$velocity$SpringResourceLoader == null ? (class$org$springframework$ui$velocity$SpringResourceLoader = VelocityEngineFactory.class$("org.springframework.ui.velocity.SpringResourceLoader")) : class$org$springframework$ui$velocity$SpringResourceLoader).getName());
                velocityEngine.setApplicationAttribute((Object)"spring.resource.loader", (Object)this.resourceLoader);
                velocityEngine.setApplicationAttribute((Object)"spring.resource.loader.path", (Object)this.resourceLoaderPath);
            }
        }
        if (this.overrideLogging) {
            velocityEngine.setProperty("runtime.log.logsystem", (Object)new CommonsLoggingLogSystem());
        }
        this.postProcessVelocityEngine(velocityEngine);
        try {
            velocityEngine.init();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (VelocityException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.logger.error((Object)"Why does VelocityEngine throw a generic checked exception, after all?", (Throwable)ex);
            throw new VelocityException(ex.getMessage());
        }
        return velocityEngine;
    }

    protected VelocityEngine newVelocityEngine() throws IOException, VelocityException {
        return new VelocityEngine();
    }

    protected void postProcessVelocityEngine(VelocityEngine velocityEngine) throws IOException, VelocityException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

