/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ojb;

import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.TransactionAbortedException;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.orm.ojb.OjbFactoryUtils;
import org.springframework.orm.ojb.PersistenceBrokerHolder;
import org.springframework.orm.ojb.PersistenceBrokerTransactionObject;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class PersistenceBrokerTransactionManager
extends AbstractPlatformTransactionManager {
    private PBKey pbKey = PersistenceBrokerFactory.getDefaultKey();
    private DataSource dataSource;

    public PersistenceBrokerTransactionManager() {
    }

    public PersistenceBrokerTransactionManager(String jcdAlias) {
        this.setJcdAlias(jcdAlias);
    }

    public PersistenceBrokerTransactionManager(PBKey pbKey) {
        this.setPbKey(pbKey);
    }

    public void setJcdAlias(String jcdAlias) {
        this.pbKey = new PBKey(jcdAlias);
    }

    public void setPbKey(PBKey pbKey) {
        this.pbKey = pbKey;
    }

    public PBKey getPbKey() {
        return this.pbKey;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected PersistenceBroker getPersistenceBroker() {
        return OjbFactoryUtils.getPersistenceBroker(this.getPbKey(), true, false);
    }

    protected void closePersistenceBrokerIfNecessary(PersistenceBroker pb) {
        OjbFactoryUtils.closePersistenceBrokerIfNecessary(pb, this.getPbKey());
    }

    protected Object doGetTransaction() {
        PersistenceBrokerTransactionObject txObject = new PersistenceBrokerTransactionObject();
        PersistenceBrokerHolder pbHolder = (PersistenceBrokerHolder)TransactionSynchronizationManager.getResource(this.getPbKey());
        txObject.setPersistenceBrokerHolder(pbHolder);
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        return TransactionSynchronizationManager.hasResource(this.getPbKey());
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        PersistenceBrokerTransactionObject txObject = (PersistenceBrokerTransactionObject)transaction;
        PersistenceBroker pb = this.getPersistenceBroker();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Opened new persistence broker [" + pb + "] for OJB transaction"));
        }
        txObject.setPersistenceBrokerHolder(new PersistenceBrokerHolder(pb));
        try {
            Connection con = pb.serviceConnectionManager().getConnection();
            Integer previousIsolationLevel = DataSourceUtils.prepareConnectionForTransaction(con, definition);
            txObject.setPreviousIsolationLevel(previousIsolationLevel);
            pb.beginTransaction();
            if (this.getDataSource() != null) {
                ConnectionHolder conHolder = new ConnectionHolder(con);
                if (definition.getTimeout() != -1) {
                    conHolder.setTimeoutInSeconds(definition.getTimeout());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Exposing OJB transaction as JDBC transaction [" + conHolder.getConnection() + "]"));
                }
                TransactionSynchronizationManager.bindResource(this.getDataSource(), conHolder);
                txObject.setConnectionHolder(conHolder);
            }
            TransactionSynchronizationManager.bindResource(this.getPbKey(), txObject.getPersistenceBrokerHolder());
        }
        catch (Exception ex) {
            this.closePersistenceBrokerIfNecessary(pb);
            throw new CannotCreateTransactionException("Could not create OJB transaction", ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        PersistenceBrokerTransactionObject txObject = (PersistenceBrokerTransactionObject)transaction;
        txObject.setPersistenceBrokerHolder(null);
        PersistenceBrokerHolder pbHolder = (PersistenceBrokerHolder)TransactionSynchronizationManager.unbindResource(this.getPbKey());
        ConnectionHolder connectionHolder = null;
        if (this.getDataSource() != null) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource(this.getDataSource());
        }
        return new SuspendedResourcesHolder(pbHolder, connectionHolder);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        if (TransactionSynchronizationManager.hasResource(this.getPbKey())) {
            TransactionSynchronizationManager.unbindResource(this.getPbKey());
        }
        TransactionSynchronizationManager.bindResource(this.getPbKey(), resourcesHolder.getPersistenceBrokerHolder());
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.bindResource(this.getDataSource(), resourcesHolder.getConnectionHolder());
        }
    }

    protected void doCommit(DefaultTransactionStatus status) {
        PersistenceBrokerTransactionObject txObject = (PersistenceBrokerTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing OJB transaction on persistence broker [" + txObject.getPersistenceBrokerHolder().getPersistenceBroker() + "]"));
        }
        try {
            txObject.getPersistenceBrokerHolder().getPersistenceBroker().commitTransaction();
        }
        catch (TransactionAbortedException ex) {
            throw new TransactionSystemException("Could not commit OJB transaction", ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        PersistenceBrokerTransactionObject txObject = (PersistenceBrokerTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back OJB transaction on persistence broker [" + txObject.getPersistenceBrokerHolder().getPersistenceBroker() + "]"));
        }
        txObject.getPersistenceBrokerHolder().getPersistenceBroker().abortTransaction();
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        PersistenceBrokerTransactionObject txObject = (PersistenceBrokerTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting OJB transaction on persistence broker [" + txObject.getPersistenceBrokerHolder().getPersistenceBroker() + "] rollback-only"));
        }
        txObject.getPersistenceBrokerHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        PersistenceBrokerTransactionObject txObject = (PersistenceBrokerTransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource(this.getPbKey());
        txObject.getPersistenceBrokerHolder().clear();
        if (this.getDataSource() != null) {
            TransactionSynchronizationManager.unbindResource(this.getDataSource());
        }
        PersistenceBroker pb = txObject.getPersistenceBrokerHolder().getPersistenceBroker();
        try {
            Connection con = pb.serviceConnectionManager().getConnection();
            DataSourceUtils.resetConnectionAfterTransaction(con, txObject.getPreviousIsolationLevel());
        }
        catch (LookupException ex) {
            this.logger.info((Object)"Could not look up JDBC connection of OJB persistence broker", (Throwable)ex);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Closing OJB persistence broker [" + pb + "] after transaction"));
        }
        this.closePersistenceBrokerIfNecessary(pb);
    }

    private static class SuspendedResourcesHolder {
        private final PersistenceBrokerHolder persistenceBrokerHolder;
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(PersistenceBrokerHolder pbHolder, ConnectionHolder conHolder) {
            this.persistenceBrokerHolder = pbHolder;
            this.connectionHolder = conHolder;
        }

        private PersistenceBrokerHolder getPersistenceBrokerHolder() {
            return this.persistenceBrokerHolder;
        }

        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }
}

