/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm;

import org.springframework.dao.OptimisticLockingFailureException;

public class ObjectOptimisticLockingFailureException
extends OptimisticLockingFailureException {
    private final Object persistentClass;
    private final Object identifier;

    public ObjectOptimisticLockingFailureException(Class persistentClass, Object identifier) {
        this(persistentClass, identifier, "Object of class [" + persistentClass.getName() + "] with identifier [" + identifier + "]: optimistic locking failed", null);
    }

    public ObjectOptimisticLockingFailureException(Class persistentClass, Object identifier, String msg, Throwable ex) {
        super(msg, ex);
        this.persistentClass = persistentClass;
        this.identifier = identifier;
    }

    public ObjectOptimisticLockingFailureException(String persistentClassName, Object identifier) {
        this(persistentClassName, identifier, "Object of class [" + persistentClassName + "] with identifier [" + identifier + "]: optimistic locking failed", null);
    }

    public ObjectOptimisticLockingFailureException(String persistentClassName, Object identifier, String msg, Throwable ex) {
        super(msg, ex);
        this.persistentClass = persistentClassName;
        this.identifier = identifier;
    }

    public Class getPersistentClass() {
        return this.persistentClass instanceof Class ? (Class)this.persistentClass : null;
    }

    public String getPersistentClassName() {
        return this.persistentClass instanceof Class ? ((Class)this.persistentClass).getName() : this.persistentClass.toString();
    }

    public Object getIdentifier() {
        return this.identifier;
    }
}

