/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.ui.context.Theme;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.EscapedErrors;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

public class RequestContext {
    private final HttpServletRequest request;
    private final Map model;
    private final WebApplicationContext webApplicationContext;
    private final Locale locale;
    private final Theme theme;
    private boolean defaultHtmlEscape;
    private UrlPathHelper urlPathHelper;
    private Map errorsMap;

    public RequestContext(HttpServletRequest request) {
        this(request, null);
    }

    public RequestContext(HttpServletRequest request, Map model) {
        this.request = request;
        this.model = model;
        this.webApplicationContext = RequestContextUtils.getWebApplicationContext((ServletRequest)request);
        this.locale = RequestContextUtils.getLocale(request);
        this.theme = RequestContextUtils.getTheme(request);
        this.defaultHtmlEscape = WebUtils.isDefaultHtmlEscape(this.webApplicationContext.getServletContext());
        this.urlPathHelper = new UrlPathHelper();
    }

    protected HttpServletRequest getRequest() {
        return this.request;
    }

    public WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setDefaultHtmlEscape(boolean defaultHtmlEscape) {
        this.defaultHtmlEscape = defaultHtmlEscape;
    }

    public boolean isDefaultHtmlEscape() {
        return this.defaultHtmlEscape;
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper != null ? urlPathHelper : new UrlPathHelper();
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    public String getContextPath() {
        return this.urlPathHelper.getContextPath(this.request);
    }

    public String getRequestUri() {
        return this.urlPathHelper.getRequestUri(this.request);
    }

    public String getMessage(String code, String defaultMessage) {
        return this.getMessage(code, null, defaultMessage, this.defaultHtmlEscape);
    }

    public String getMessage(String code, Object[] args, String defaultMessage) {
        return this.getMessage(code, args, defaultMessage, this.defaultHtmlEscape);
    }

    public String getMessage(String code, Object[] args, String defaultMessage, boolean htmlEscape) {
        String msg = this.webApplicationContext.getMessage(code, args, defaultMessage, this.locale);
        return htmlEscape ? HtmlUtils.htmlEscape(msg) : msg;
    }

    public String getMessage(String code) throws NoSuchMessageException {
        return this.getMessage(code, null, this.defaultHtmlEscape);
    }

    public String getMessage(String code, Object[] args) throws NoSuchMessageException {
        return this.getMessage(code, args, this.defaultHtmlEscape);
    }

    public String getMessage(String code, Object[] args, boolean htmlEscape) throws NoSuchMessageException {
        String msg = this.webApplicationContext.getMessage(code, args, this.locale);
        return htmlEscape ? HtmlUtils.htmlEscape(msg) : msg;
    }

    public String getMessage(MessageSourceResolvable resolvable) throws NoSuchMessageException {
        return this.getMessage(resolvable, this.defaultHtmlEscape);
    }

    public String getMessage(MessageSourceResolvable resolvable, boolean htmlEscape) throws NoSuchMessageException {
        String msg = this.webApplicationContext.getMessage(resolvable, this.locale);
        return htmlEscape ? HtmlUtils.htmlEscape(msg) : msg;
    }

    public String getThemeMessage(String code, String defaultMessage) {
        return this.theme.getMessageSource().getMessage(code, null, defaultMessage, this.locale);
    }

    public String getThemeMessage(String code, String[] args, String defaultMessage) {
        return this.theme.getMessageSource().getMessage(code, args, defaultMessage, this.locale);
    }

    public String getThemeMessage(String code) throws NoSuchMessageException {
        return this.theme.getMessageSource().getMessage(code, null, this.locale);
    }

    public String getThemeMessage(String code, String[] args) throws NoSuchMessageException {
        return this.theme.getMessageSource().getMessage(code, args, this.locale);
    }

    public String getThemeMessage(MessageSourceResolvable resolvable) throws NoSuchMessageException {
        return this.theme.getMessageSource().getMessage(resolvable, this.locale);
    }

    public Errors getErrors(String name) {
        return this.getErrors(name, this.defaultHtmlEscape);
    }

    public Errors getErrors(String name, boolean htmlEscape) {
        if (this.errorsMap == null) {
            this.errorsMap = new HashMap();
        }
        Errors errors = (Errors)this.errorsMap.get(name);
        boolean put = false;
        if (errors == null) {
            errors = this.retrieveErrors(name);
            if (errors == null) {
                return null;
            }
            put = true;
        }
        if (htmlEscape && !(errors instanceof EscapedErrors)) {
            errors = new EscapedErrors(errors);
            put = true;
        } else if (!htmlEscape && errors instanceof EscapedErrors) {
            errors = ((EscapedErrors)errors).getSource();
            put = true;
        }
        if (put) {
            this.errorsMap.put(name, errors);
        }
        return errors;
    }

    private Errors retrieveErrors(String name) {
        String key = BindException.ERROR_KEY_PREFIX + name;
        if (this.model != null) {
            return (Errors)this.model.get(key);
        }
        return (Errors)this.request.getAttribute(key);
    }

    public BindStatus getBindStatus(String path) throws IllegalStateException {
        return new BindStatus(this, path, this.defaultHtmlEscape);
    }

    public BindStatus getBindStatus(String path, boolean htmlEscape) throws IllegalStateException {
        return new BindStatus(this, path, htmlEscape);
    }
}

