/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.ui.freemarker.SpringTemplateLoader;

public class FreeMarkerConfigurationFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private Properties freemarkerSettings;
    private Map freemarkerVariables;
    private String templateLoaderPath;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();

    public void setConfigLocation(Resource resource) {
        this.configLocation = resource;
    }

    public void setFreemarkerSettings(Properties settings) {
        this.freemarkerSettings = settings;
    }

    public void setFreemarkerVariables(Map variables) {
        this.freemarkerVariables = variables;
    }

    public void setTemplateLoaderPath(String templateLoaderPath) {
        this.templateLoaderPath = templateLoaderPath;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration createConfiguration() throws IOException, TemplateException {
        Configuration config = this.newConfiguration();
        Properties props = new Properties();
        if (this.configLocation != null) {
            this.logger.info((Object)("Loading FreeMarker config from [" + this.configLocation + "]"));
            InputStream is = this.configLocation.getInputStream();
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
        }
        if (this.freemarkerSettings != null) {
            props.putAll((Map<?, ?>)this.freemarkerSettings);
        }
        if (!props.isEmpty()) {
            config.setSettings(props);
        }
        if (this.freemarkerVariables != null && this.freemarkerVariables.size() > 0) {
            config.setAllSharedVariables((TemplateHashModelEx)new SimpleHash(this.freemarkerVariables));
        }
        if (this.templateLoaderPath != null) {
            Resource path = this.resourceLoader.getResource(this.templateLoaderPath);
            try {
                config.setDirectoryForTemplateLoading(path.getFile());
            }
            catch (IOException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Cannot resolve template loader path [" + this.templateLoaderPath + "] to File: using SpringTemplateLoader"), (Throwable)ex);
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Cannot resolve template loader path [" + this.templateLoaderPath + "] to File: using SpringTemplateLoader"));
                }
                config.setTemplateLoader((TemplateLoader)new SpringTemplateLoader(this.resourceLoader, this.templateLoaderPath));
            }
        }
        this.postProcessConfiguration(config);
        return config;
    }

    protected Configuration newConfiguration() throws IOException, TemplateException {
        return new Configuration();
    }

    protected void postProcessConfiguration(Configuration config) throws IOException, TemplateException {
    }
}

