/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.rmi;

import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiObjectLocator;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.rmi.RmiClientInterceptorUtils;

public class JndiRmiClientInterceptor
extends JndiObjectLocator
implements MethodInterceptor,
InitializingBean {
    private Class serviceInterface;
    private boolean lookupStubOnStartup = true;
    private boolean cacheStub = true;
    private boolean refreshStubOnConnectFailure = false;
    private Remote cachedStub;
    static /* synthetic */ Class class$java$rmi$Remote;

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("serviceInterface must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setLookupStubOnStartup(boolean lookupStubOnStartup) {
        this.lookupStubOnStartup = lookupStubOnStartup;
    }

    public void setCacheStub(boolean cacheStub) {
        this.cacheStub = cacheStub;
    }

    public void setRefreshStubOnConnectFailure(boolean refreshStubOnConnectFailure) {
        this.refreshStubOnConnectFailure = refreshStubOnConnectFailure;
    }

    public void afterPropertiesSet() throws NamingException {
        super.afterPropertiesSet();
        if (this.lookupStubOnStartup) {
            Remote stub = this.lookupStub();
            if (this.cacheStub) {
                this.cachedStub = stub;
            }
        }
    }

    protected Remote lookupStub() throws NamingException {
        Object stub = this.lookup();
        if (this.getServiceInterface() != null && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = JndiRmiClientInterceptor.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(this.getServiceInterface())) {
            stub = PortableRemoteObject.narrow((Object)stub, (Class)this.getServiceInterface());
        }
        if (!(stub instanceof Remote)) {
            throw new AspectException("Located RMI stub [" + stub + "] does not implement java.rmi.Remote");
        }
        return (Remote)stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Remote getStub() throws NamingException {
        if (!this.cacheStub || this.lookupStubOnStartup && !this.refreshStubOnConnectFailure) {
            return this.cachedStub != null ? this.cachedStub : this.lookupStub();
        }
        JndiRmiClientInterceptor jndiRmiClientInterceptor = this;
        synchronized (jndiRmiClientInterceptor) {
            if (this.cachedStub == null) {
                this.cachedStub = this.lookupStub();
            }
            return this.cachedStub;
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Remote stub = null;
        try {
            stub = this.getStub();
        }
        catch (Throwable ex) {
            throw new RemoteLookupFailureException("RMI lookup for service [" + this.getJndiName() + "] failed", ex);
        }
        try {
            return this.doInvoke(invocation, stub);
        }
        catch (RemoteConnectFailureException ex) {
            return this.handleRemoteConnectFailure(invocation, ex);
        }
        catch (RemoteException ex) {
            if (RmiClientInterceptorUtils.isConnectFailure(ex)) {
                return this.handleRemoteConnectFailure(invocation, ex);
            }
            throw ex;
        }
    }

    private Object handleRemoteConnectFailure(MethodInvocation invocation, Exception ex) throws Throwable {
        if (this.refreshStubOnConnectFailure) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not connect to RMI service [" + this.getJndiName() + "] - retrying"), (Throwable)ex);
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Could not connect to RMI service [" + this.getJndiName() + "] - retrying"));
            }
            return this.refreshAndRetry(invocation);
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object refreshAndRetry(MethodInvocation invocation) throws Throwable {
        Remote freshStub = null;
        JndiRmiClientInterceptor jndiRmiClientInterceptor = this;
        synchronized (jndiRmiClientInterceptor) {
            try {
                freshStub = this.lookupStub();
                if (this.cacheStub) {
                    this.cachedStub = freshStub;
                }
            }
            catch (Throwable ex) {
                throw new RemoteLookupFailureException("RMI lookup for service [" + this.getJndiName() + "] failed", ex);
            }
        }
        return this.doInvoke(invocation, freshStub);
    }

    protected Object doInvoke(MethodInvocation invocation, Remote stub) throws Throwable {
        return RmiClientInterceptorUtils.invoke(invocation, stub, this.getJndiName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

