/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.StringUtils;

public class DefaultListableBeanFactory
extends AbstractAutowireCapableBeanFactory
implements ConfigurableListableBeanFactory,
BeanDefinitionRegistry {
    private boolean allowBeanDefinitionOverriding = true;
    private final Map beanDefinitionMap = new HashMap();
    private final List beanDefinitionNames = new LinkedList();
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;

    public DefaultListableBeanFactory() {
    }

    public DefaultListableBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public int getBeanDefinitionCount() {
        return this.beanDefinitionMap.size();
    }

    public String[] getBeanDefinitionNames() {
        return this.getBeanDefinitionNames(null);
    }

    public String[] getBeanDefinitionNames(Class type) {
        ArrayList<String> matches = new ArrayList<String>();
        Iterator it = this.beanDefinitionNames.iterator();
        while (it.hasNext()) {
            String beanName = (String)it.next();
            if (!this.isBeanDefinitionTypeMatch(beanName, type)) continue;
            matches.add(beanName);
        }
        return matches.toArray(new String[matches.size()]);
    }

    private boolean isBeanDefinitionTypeMatch(String beanName, Class type) {
        if (type == null) {
            return true;
        }
        RootBeanDefinition rbd = this.getMergedBeanDefinition(beanName, false);
        return rbd.hasBeanClass() && type.isAssignableFrom(rbd.getBeanClass());
    }

    public boolean containsBeanDefinition(String beanName) {
        return this.beanDefinitionMap.containsKey(beanName);
    }

    public Map getBeansOfType(Class type) throws BeansException {
        return this.getBeansOfType(type, true, true);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean includeFactoryBeans) throws BeansException {
        HashMap result = new HashMap();
        Iterator it = this.beanDefinitionNames.iterator();
        while (it.hasNext()) {
            String beanName = (String)it.next();
            RootBeanDefinition rbd = this.getMergedBeanDefinition(beanName, false);
            if (rbd.isAbstract() || !rbd.hasBeanClass() || !includePrototypes && !rbd.isSingleton()) continue;
            if ((class$org$springframework$beans$factory$FactoryBean == null ? DefaultListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean") : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(rbd.getBeanClass())) {
                if (!includeFactoryBeans || !includePrototypes && !this.isSingleton(beanName) || !this.isBeanTypeMatch(beanName, type)) continue;
                this.addBeanToResultMap(beanName, result);
                continue;
            }
            if (type != null && !type.isAssignableFrom(rbd.getBeanClass())) continue;
            this.addBeanToResultMap(beanName, result);
        }
        String[] singletonNames = this.getSingletonNames();
        for (int i = 0; i < singletonNames.length; ++i) {
            String beanName = singletonNames[i];
            if (this.containsBeanDefinition(beanName) || !this.isSingleton(beanName) || !this.isBeanTypeMatch(beanName, type) || !includeFactoryBeans && this.isFactoryBean(beanName)) continue;
            this.addBeanToResultMap(beanName, result);
        }
        return result;
    }

    private boolean isBeanTypeMatch(String beanName, Class type) {
        if (type == null) {
            return true;
        }
        Class beanType = this.getType(beanName);
        return beanType != null && type.isAssignableFrom(beanType);
    }

    private void addBeanToResultMap(String beanName, Map result) {
        block2: {
            try {
                result.put(beanName, this.getBean(beanName));
            }
            catch (BeanCurrentlyInCreationException ex) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)("Ignoring match to currently created bean '" + beanName + "'"));
            }
        }
    }

    public void preInstantiateSingletons() throws BeansException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Pre-instantiating singletons in factory [" + this + "]"));
        }
        try {
            Iterator it = this.beanDefinitionNames.iterator();
            while (it.hasNext()) {
                RootBeanDefinition bd;
                String beanName = (String)it.next();
                if (!this.containsBeanDefinition(beanName) || !(bd = this.getMergedBeanDefinition(beanName, false)).hasBeanClass() || bd.isAbstract() || !bd.isSingleton() || bd.isLazyInit()) continue;
                if ((class$org$springframework$beans$factory$FactoryBean == null ? DefaultListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean") : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(bd.getBeanClass())) {
                    FactoryBean factory = (FactoryBean)this.getBean("&" + beanName);
                    if (!factory.isSingleton()) continue;
                    this.getBean(beanName);
                    continue;
                }
                this.getBean(beanName);
            }
        }
        catch (BeansException ex) {
            try {
                this.destroySingletons();
            }
            catch (Throwable ex2) {
                this.logger.error((Object)"Pre-instantiating singletons failed, and couldn't destroy already created singletons", ex2);
            }
            throw ex;
        }
    }

    public void registerBeanDefinition(String name, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        Object oldBeanDefinition;
        if (beanDefinition instanceof AbstractBeanDefinition) {
            try {
                ((AbstractBeanDefinition)beanDefinition).validate();
            }
            catch (BeanDefinitionValidationException ex) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), name, "Validation of bean definition with name failed", (Throwable)ex);
            }
        }
        if ((oldBeanDefinition = this.beanDefinitionMap.get(name)) != null) {
            if (!this.allowBeanDefinitionOverriding) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), name, "Cannot register bean definition [" + beanDefinition + "] for bean '" + name + "': there's already [" + oldBeanDefinition + "] bound");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Overriding bean definition for bean '" + name + "': replacing [" + oldBeanDefinition + "] with [" + beanDefinition + "]"));
            }
        } else {
            this.beanDefinitionNames.add(name);
        }
        this.beanDefinitionMap.put(name, beanDefinition);
        this.removeSingleton(name);
    }

    public BeanDefinition getBeanDefinition(String beanName) throws BeansException {
        BeanDefinition bd = (BeanDefinition)this.beanDefinitionMap.get(beanName);
        if (bd == null) {
            throw new NoSuchBeanDefinitionException(beanName, this.toString());
        }
        return bd;
    }

    protected Map findMatchingBeans(Class requiredType) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors(this, requiredType);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(" defining beans [");
        sb.append(StringUtils.arrayToDelimitedString(this.getBeanDefinitionNames(), ","));
        sb.append("]; ");
        if (this.getParentBeanFactory() == null) {
            sb.append("root of BeanFactory hierarchy");
        } else {
            sb.append("parent: " + this.getParentBeanFactory());
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

