/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;

public class PropertyOverrideConfigurer
extends PropertyResourceConfigurer {
    private Set beanNames = Collections.synchronizedSet(new HashSet());

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            this.processKey(beanFactory, key, props.getProperty(key));
        }
    }

    protected void processKey(ConfigurableListableBeanFactory factory, String key, String value) throws BeansException {
        int dotIndex = key.indexOf(46);
        if (dotIndex == -1) {
            throw new FatalBeanException("Invalid key [" + key + "]: expected 'beanName.property'");
        }
        String beanName = key.substring(0, dotIndex);
        String beanProperty = key.substring(dotIndex + 1);
        this.beanNames.add(beanName);
        this.applyPropertyValue(factory, beanName, beanProperty, value);
        this.logger.debug((Object)("Property '" + key + "' set to [" + value + "]"));
    }

    protected void applyPropertyValue(ConfigurableListableBeanFactory factory, String beanName, String property, String value) {
        BeanDefinition bd = factory.getBeanDefinition(beanName);
        bd.getPropertyValues().addPropertyValue(property, value);
    }

    public boolean hasPropertyOverridesFor(String beanName) {
        return this.beanNames.contains(beanName);
    }
}

