/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyFactory;
import org.springframework.aop.framework.Cglib2AopProxy;
import org.springframework.aop.framework.JdkDynamicAopProxy;

public class DefaultAopProxyFactory
implements AopProxyFactory {
    public AopProxy createAopProxy(AdvisedSupport advisedSupport) throws AopConfigException {
        if (advisedSupport.isOptimize() || advisedSupport.isProxyTargetClass() || advisedSupport.getProxiedInterfaces().length == 0) {
            return CglibProxyFactory.createCglibProxy(advisedSupport);
        }
        return new JdkDynamicAopProxy(advisedSupport);
    }

    private static class CglibProxyFactory {
        private CglibProxyFactory() {
        }

        private static AopProxy createCglibProxy(AdvisedSupport advisedSupport) {
            return new Cglib2AopProxy(advisedSupport);
        }
    }
}

