/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.util.Properties;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSourceAdvisor;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class TransactionProxyFactoryBean
extends ProxyConfig
implements FactoryBean,
InitializingBean {
    private final TransactionInterceptor transactionInterceptor = new TransactionInterceptor();
    private Object target;
    private Class[] proxyInterfaces;
    private Pointcut pointcut;
    private Object[] preInterceptors;
    private Object[] postInterceptors;
    private AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
    private Object proxy;

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionInterceptor.setTransactionManager(transactionManager);
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setProxyInterfaces(String[] interfaceNames) throws ClassNotFoundException {
        this.proxyInterfaces = AopUtils.toInterfaceArray(interfaceNames);
    }

    public void setTransactionAttributes(Properties transactionAttributes) {
        this.transactionInterceptor.setTransactionAttributes(transactionAttributes);
    }

    public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
        this.transactionInterceptor.setTransactionAttributeSource(transactionAttributeSource);
    }

    public void setPointcut(Pointcut pointcut) {
        this.pointcut = pointcut;
    }

    public void setPreInterceptors(Object[] preInterceptors) {
        this.preInterceptors = preInterceptors;
    }

    public void setPostInterceptors(Object[] preInterceptors) {
        this.postInterceptors = preInterceptors;
    }

    public void setAdvisorAdapterRegistry(AdvisorAdapterRegistry advisorAdapterRegistry) {
        this.advisorAdapterRegistry = advisorAdapterRegistry;
    }

    public void afterPropertiesSet() throws AopConfigException {
        this.transactionInterceptor.afterPropertiesSet();
        if (this.target == null) {
            throw new IllegalArgumentException("'target' is required");
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        if (this.preInterceptors != null) {
            for (int i = 0; i < this.preInterceptors.length; ++i) {
                proxyFactory.addAdvisor(this.advisorAdapterRegistry.wrap(this.preInterceptors[i]));
            }
        }
        if (this.pointcut != null) {
            DefaultPointcutAdvisor advice = new DefaultPointcutAdvisor(this.pointcut, (Advice)this.transactionInterceptor);
            proxyFactory.addAdvisor(advice);
        } else {
            proxyFactory.addAdvisor(new TransactionAttributeSourceAdvisor(this.transactionInterceptor));
        }
        if (this.postInterceptors != null) {
            for (int i = 0; i < this.postInterceptors.length; ++i) {
                proxyFactory.addAdvisor(this.advisorAdapterRegistry.wrap(this.postInterceptors[i]));
            }
        }
        proxyFactory.copyFrom(this);
        proxyFactory.setTargetSource(this.createTargetSource(this.target));
        if (this.proxyInterfaces != null) {
            proxyFactory.setInterfaces(this.proxyInterfaces);
        } else if (!this.getProxyTargetClass()) {
            if (this.target instanceof TargetSource) {
                throw new AopConfigException("Either 'proxyInterfaces' or 'proxyTargetClass' is required when using a TargetSource as 'target");
            }
            proxyFactory.setInterfaces(AopUtils.getAllInterfaces(this.target));
        }
        this.proxy = proxyFactory.getProxy();
    }

    protected TargetSource createTargetSource(Object target) {
        if (target instanceof TargetSource) {
            return (TargetSource)target;
        }
        return new SingletonTargetSource(target);
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class getObjectType() {
        if (this.proxy != null) {
            return this.proxy.getClass();
        }
        if (this.target != null && this.target instanceof TargetSource) {
            return this.target.getClass();
        }
        return null;
    }

    public boolean isSingleton() {
        return true;
    }
}

