/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.httpinvoker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;

public abstract class AbstractHttpInvokerRequestExecutor
implements HttpInvokerRequestExecutor {
    private static final int SERIALIZED_INVOCATION_BYTE_ARRAY_INITIAL_SIZE = 500;
    protected static final String CONTENT_TYPE_SERIALIZED_OBJECT = "application/x-java-serialized-object";
    protected static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    protected static final String HTTP_HEADER_CONTENT_LENGTH = "Content-Length";
    protected static final String HTTP_METHOD_POST = "POST";
    protected final Log logger = LogFactory.getLog(this.getClass());

    public final RemoteInvocationResult executeRequest(HttpInvokerClientConfiguration config, RemoteInvocation invocation) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = this.getByteArrayOutputStream(invocation);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Sending HTTP invoker request for service at [" + config.getServiceUrl() + "], with size " + baos.size()));
        }
        return this.doExecuteRequest(config, baos);
    }

    protected ByteArrayOutputStream getByteArrayOutputStream(RemoteInvocation invocation) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(500);
        this.writeRemoteInvocation(invocation, baos);
        return baos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRemoteInvocation(RemoteInvocation invocation, OutputStream os) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(os);
        try {
            oos.writeObject(invocation);
        }
        finally {
            oos.close();
        }
    }

    protected abstract RemoteInvocationResult doExecuteRequest(HttpInvokerClientConfiguration var1, ByteArrayOutputStream var2) throws IOException, ClassNotFoundException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteInvocationResult readRemoteInvocationResult(InputStream is) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            Object obj = ois.readObject();
            if (!(obj instanceof RemoteInvocationResult)) {
                throw new IOException("Deserialized object needs to be a RemoteInvocationResult: " + obj);
            }
            RemoteInvocationResult remoteInvocationResult = (RemoteInvocationResult)obj;
            return remoteInvocationResult;
        }
        finally {
            ois.close();
        }
    }
}

