/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate.support;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.UserType;
import net.sf.hibernate.util.EqualsHelper;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.orm.hibernate.LocalSessionFactoryBean;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractLobType
implements UserType {
    private final LobHandler lobHandler;

    protected AbstractLobType() {
        this(LocalSessionFactoryBean.getConfigTimeLobHandler());
    }

    protected AbstractLobType(LobHandler lobHandler) {
        if (lobHandler == null) {
            throw new IllegalStateException("No LobHandler found for configuration - lobHandler property must be set on LocalSessionFactoryBean");
        }
        this.lobHandler = lobHandler;
    }

    public boolean equals(Object x, Object y) {
        return EqualsHelper.equals((Object)x, (Object)y);
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public final Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws SQLException {
        return this.nullSafeGetInternal(rs, rs.findColumn(names[0]), this.lobHandler);
    }

    public final void nullSafeSet(PreparedStatement st, Object value, int index) throws SQLException {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            throw new IllegalStateException("Active transaction synchronization required");
        }
        LobCreator lobCreator = this.lobHandler.getLobCreator();
        this.nullSafeSetInternal(st, index, value, lobCreator);
        TransactionSynchronizationManager.registerSynchronization(new LobCreatorSynchronization(lobCreator));
    }

    protected abstract Object nullSafeGetInternal(ResultSet var1, int var2, LobHandler var3) throws SQLException;

    protected abstract void nullSafeSetInternal(PreparedStatement var1, int var2, Object var3, LobCreator var4) throws SQLException;

    private static class LobCreatorSynchronization
    extends TransactionSynchronizationAdapter {
        private final LobCreator lobCreator;

        private LobCreatorSynchronization(LobCreator lobCreator) {
            this.lobCreator = lobCreator;
        }

        public void beforeCompletion() {
            this.lobCreator.close();
        }
    }
}

