/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.StringUtils;

public class DefaultListableBeanFactory
extends AbstractAutowireCapableBeanFactory
implements ConfigurableListableBeanFactory,
BeanDefinitionRegistry {
    private boolean allowBeanDefinitionOverriding = true;
    private final Map beanDefinitionMap = new HashMap();
    private final List beanDefinitionNames = new LinkedList();
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;

    public DefaultListableBeanFactory() {
    }

    public DefaultListableBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public int getBeanDefinitionCount() {
        return this.beanDefinitionMap.size();
    }

    public String[] getBeanDefinitionNames() {
        return this.getBeanDefinitionNames(null);
    }

    public String[] getBeanDefinitionNames(Class type) {
        ArrayList<String> matches = new ArrayList<String>();
        Iterator it = this.beanDefinitionNames.iterator();
        while (it.hasNext()) {
            String beanName = (String)it.next();
            if (!this.isBeanDefinitionTypeMatch(beanName, type)) continue;
            matches.add(beanName);
        }
        return matches.toArray(new String[matches.size()]);
    }

    protected boolean isBeanDefinitionTypeMatch(String beanName, Class type) {
        if (type == null) {
            return true;
        }
        RootBeanDefinition rbd = this.getMergedBeanDefinition(beanName, false);
        return rbd.hasBeanClass() && type.isAssignableFrom(rbd.getBeanClass());
    }

    public boolean containsBeanDefinition(String beanName) {
        return this.beanDefinitionMap.containsKey(beanName);
    }

    public Map getBeansOfType(Class type, boolean includePrototypes, boolean includeFactoryBeans) throws BeansException {
        String[] beanNames = this.getBeanDefinitionNames(type);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < beanNames.length; ++i) {
            if (!includePrototypes && !this.isSingleton(beanNames[i])) continue;
            try {
                result.put(beanNames[i], this.getBean(beanNames[i]));
                continue;
            }
            catch (BeanCurrentlyInCreationException ex) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Ignoring match to currently created bean '" + beanNames[i] + "'"));
            }
        }
        String[] singletonNames = this.getSingletonNames(type);
        for (int i = 0; i < singletonNames.length; ++i) {
            if (this.containsBeanDefinition(singletonNames[i])) continue;
            try {
                result.put(singletonNames[i], this.getBean(singletonNames[i]));
                continue;
            }
            catch (BeanCurrentlyInCreationException ex) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Ignoring match to currently created bean '" + singletonNames[i] + "'"));
            }
        }
        if (includeFactoryBeans) {
            String[] factoryNames = this.getBeanDefinitionNames(class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = DefaultListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean);
            for (int i = 0; i < factoryNames.length; ++i) {
                try {
                    Object createdObject;
                    FactoryBean factory = (FactoryBean)this.getBean("&" + factoryNames[i]);
                    Class objectType = factory.getObjectType();
                    if ((objectType != null || !factory.isSingleton()) && (!factory.isSingleton() && !includePrototypes || objectType == null || !type.isAssignableFrom(objectType)) || !type.isInstance(createdObject = this.getBean(factoryNames[i]))) continue;
                    result.put(factoryNames[i], createdObject);
                    continue;
                }
                catch (BeanCurrentlyInCreationException ex) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Ignoring match to currently created bean '" + factoryNames[i] + "'"));
                    continue;
                }
                catch (BeanCreationException ex) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)"Ignoring FactoryBean creation failure when looking for matching beans", (Throwable)ex);
                }
            }
        }
        return result;
    }

    public void preInstantiateSingletons() throws BeansException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Pre-instantiating singletons in factory [" + this + "]"));
        }
        try {
            Iterator it = this.beanDefinitionNames.iterator();
            while (it.hasNext()) {
                RootBeanDefinition bd;
                String beanName = (String)it.next();
                if (!this.containsBeanDefinition(beanName) || !(bd = this.getMergedBeanDefinition(beanName, false)).hasBeanClass() || !bd.isSingleton() || bd.isLazyInit()) continue;
                if ((class$org$springframework$beans$factory$FactoryBean == null ? DefaultListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean") : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(bd.getBeanClass())) {
                    FactoryBean factory = (FactoryBean)this.getBean("&" + beanName);
                    if (!factory.isSingleton()) continue;
                    this.getBean(beanName);
                    continue;
                }
                this.getBean(beanName);
            }
        }
        catch (BeansException ex) {
            try {
                this.destroySingletons();
            }
            catch (Throwable ex2) {
                this.logger.error((Object)"preInstantiateSingletons failed but couldn't destroy already created singletons", ex2);
            }
            throw ex;
        }
    }

    public void registerBeanDefinition(String name, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        Object oldBeanDefinition;
        if (beanDefinition instanceof AbstractBeanDefinition) {
            try {
                ((AbstractBeanDefinition)beanDefinition).validate();
            }
            catch (BeanDefinitionValidationException ex) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), name, "Validation of bean definition with name failed", (Throwable)ex);
            }
        }
        if ((oldBeanDefinition = this.beanDefinitionMap.get(name)) != null) {
            if (!this.allowBeanDefinitionOverriding) {
                throw new BeanDefinitionStoreException("Cannot register bean definition [" + beanDefinition + "] for bean '" + name + "': there's already [" + oldBeanDefinition + "] bound");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Overriding bean definition for bean '" + name + "': replacing [" + oldBeanDefinition + "] with [" + beanDefinition + "]"));
            }
        } else {
            this.beanDefinitionNames.add(name);
        }
        this.beanDefinitionMap.put(name, beanDefinition);
    }

    public BeanDefinition getBeanDefinition(String beanName) throws BeansException {
        BeanDefinition bd = (BeanDefinition)this.beanDefinitionMap.get(beanName);
        if (bd == null) {
            throw new NoSuchBeanDefinitionException(beanName, this.toString());
        }
        return bd;
    }

    protected String[] getDependingBeanNames(String beanName) throws BeansException {
        ArrayList<String> dependingBeanNames = new ArrayList<String>();
        String[] beanDefinitionNames = this.getBeanDefinitionNames();
        for (int i = 0; i < beanDefinitionNames.length; ++i) {
            List<String> dependsOn;
            RootBeanDefinition bd;
            if (!this.containsBeanDefinition(beanDefinitionNames[i]) || (bd = this.getMergedBeanDefinition(beanDefinitionNames[i], false)).getDependsOn() == null || !(dependsOn = Arrays.asList(bd.getDependsOn())).contains(beanName)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found depending bean '" + beanDefinitionNames[i] + "' for bean '" + beanName + "'"));
            }
            dependingBeanNames.add(beanDefinitionNames[i]);
        }
        return dependingBeanNames.toArray(new String[dependingBeanNames.size()]);
    }

    protected Map findMatchingBeans(Class requiredType) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors(this, requiredType, true, true);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append(" defining beans [" + StringUtils.arrayToDelimitedString(this.getBeanDefinitionNames(), ",") + "]");
        if (this.getParentBeanFactory() == null) {
            sb.append("; Root of BeanFactory hierarchy");
        } else {
            sb.append("; parent=<" + this.getParentBeanFactory() + ">");
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

