/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public abstract class AbstractTemplateView
extends AbstractUrlBasedView {
    public static final String SPRING_MACRO_REQUEST_CONTEXT_ATTRIBUTE = "springMacroRequestContext";
    private boolean exposeRequestAttributes = false;
    private boolean exposeSessionAttributes = false;
    private boolean exposeSpringMacroHelpers = false;

    public void setExposeRequestAttributes(boolean exposeRequestAttributes) {
        this.exposeRequestAttributes = exposeRequestAttributes;
    }

    public void setExposeSessionAttributes(boolean exposeSessionAttributes) {
        this.exposeSessionAttributes = exposeSessionAttributes;
    }

    public void setExposeSpringMacroHelpers(boolean exposeSpringMacroHelpers) {
        this.exposeSpringMacroHelpers = exposeSpringMacroHelpers;
    }

    protected final void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session;
        if (this.exposeRequestAttributes) {
            Enumeration enumeration = request.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String attribute = (String)enumeration.nextElement();
                if (model.containsKey(attribute)) {
                    throw new ServletException("Cannot expose request attribute '" + attribute + "' because of an existing model object of the same name");
                }
                Object attributeValue = request.getAttribute(attribute);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Exposing request attribute '" + attribute + "' with value [" + attributeValue + "] to model"));
                }
                model.put(attribute, attributeValue);
            }
        }
        if (this.exposeSessionAttributes && (session = request.getSession(false)) != null) {
            Enumeration enumeration = session.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String attribute = (String)enumeration.nextElement();
                if (model.containsKey(attribute)) {
                    throw new ServletException("Cannot expose session attribute '" + attribute + "' because of an existing model object of the same name");
                }
                Object attributeValue = session.getAttribute(attribute);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Exposing session attribute '" + attribute + "' with value [" + attributeValue + "] to model"));
                }
                model.put(attribute, attributeValue);
            }
        }
        if (this.exposeSpringMacroHelpers) {
            if (model.containsKey(SPRING_MACRO_REQUEST_CONTEXT_ATTRIBUTE)) {
                throw new ServletException("Cannot expose bind macro helper 'springMacroRequestContext' because of an existing model object of the same name");
            }
            model.put(SPRING_MACRO_REQUEST_CONTEXT_ATTRIBUTE, new RequestContext(request, model));
        }
        this.renderMergedTemplateModel(model, request, response);
    }

    protected abstract void renderMergedTemplateModel(Map var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;
}

