/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;

public class WebSphereNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private static final String JDBC_ADAPTER_CONNECTION_NAME = "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection";
    private static final String JDBC_ADAPTER_UTIL_NAME = "com.ibm.ws.rsadapter.jdbc.WSJdbcUtil";
    private final Class jdbcAdapterConnectionClass = this.getClass().getClassLoader().loadClass("com.ibm.ws.rsadapter.jdbc.WSJdbcConnection");
    private final Method getNativeConnectionMethod;

    public WebSphereNativeJdbcExtractor() throws ClassNotFoundException, NoSuchMethodException {
        Class<?> jdbcAdapterUtilClass = this.getClass().getClassLoader().loadClass(JDBC_ADAPTER_UTIL_NAME);
        this.getNativeConnectionMethod = jdbcAdapterUtilClass.getMethod("getNativeConnection", this.jdbcAdapterConnectionClass);
    }

    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return true;
    }

    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        if (this.jdbcAdapterConnectionClass.isAssignableFrom(con.getClass())) {
            try {
                return (Connection)this.getNativeConnectionMethod.invoke(null, con);
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not invoke WebSphere's getNativeConnection method", ex);
            }
        }
        return con;
    }
}

