/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Enumeration;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;

public class PropertyOverrideConfigurer
extends PropertyResourceConfigurer {
    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            this.processKey(beanFactory, key, props.getProperty(key));
        }
    }

    protected void processKey(ConfigurableListableBeanFactory factory, String key, String value) throws BeansException {
        int dotIndex = key.indexOf(46);
        if (dotIndex == -1) {
            throw new FatalBeanException("Invalid key [" + key + "]: expected 'beanName.property'");
        }
        String beanName = key.substring(0, dotIndex);
        String beanProperty = key.substring(dotIndex + 1);
        BeanDefinition bd = factory.getBeanDefinition(beanName);
        bd.getPropertyValues().addPropertyValue(beanProperty, value);
        this.logger.debug((Object)("Property '" + key + "' set to [" + value + "]"));
    }
}

