/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class RedirectView
extends AbstractUrlBasedView {
    public static final String DEFAULT_ENCODING_SCHEME = "UTF-8";
    private boolean contextRelative = false;
    private String encodingScheme = "UTF-8";

    public RedirectView() {
    }

    public RedirectView(String url) {
        this.setUrl(url);
    }

    public RedirectView(String url, boolean contextRelative) {
        this.setUrl(url);
        this.contextRelative = contextRelative;
    }

    public void setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
    }

    public void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer targetUrl = new StringBuffer();
        if (this.contextRelative) {
            targetUrl.append(request.getContextPath());
        }
        targetUrl.append(this.getUrl());
        this.appendQueryProperties(targetUrl, model, this.encodingScheme);
        response.sendRedirect(response.encodeRedirectURL(targetUrl.toString()));
    }

    protected void appendQueryProperties(StringBuffer targetUrl, Map model, String encodingScheme) throws UnsupportedEncodingException {
        boolean first = this.getUrl().indexOf(63) < 0;
        Iterator entries = this.queryProperties(model).entrySet().iterator();
        while (entries.hasNext()) {
            if (first) {
                targetUrl.append('?');
                first = false;
            } else {
                targetUrl.append('&');
            }
            Map.Entry entry = entries.next();
            String encodedKey = URLEncoder.encode(entry.getKey().toString());
            String encodedValue = entry.getValue() != null ? URLEncoder.encode(entry.getValue().toString()) : "";
            targetUrl.append(new String(encodedKey.getBytes(encodingScheme), encodingScheme));
            targetUrl.append("=");
            targetUrl.append(new String(encodedValue.getBytes(encodingScheme), encodingScheme));
        }
    }

    protected Map queryProperties(Map model) {
        return model;
    }
}

