/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.jdo.JdoAccessor;
import org.springframework.orm.jdo.JdoCallback;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JdoTemplate
extends JdoAccessor {
    private boolean allowCreate = true;

    public JdoTemplate() {
    }

    public JdoTemplate(PersistenceManagerFactory pmf) {
        this.setPersistenceManagerFactory(pmf);
        this.afterPropertiesSet();
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public Object execute(JdoCallback action) throws DataAccessException {
        PersistenceManager pm = PersistenceManagerFactoryUtils.getPersistenceManager(this.getPersistenceManagerFactory(), this.allowCreate);
        boolean existingTransaction = TransactionSynchronizationManager.hasResource(this.getPersistenceManagerFactory());
        try {
            Object result = action.doInJdo(pm);
            this.flushIfNecessary(pm, existingTransaction);
            Object object = result;
            return object;
        }
        catch (JDOException ex) {
            throw this.convertJdoAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(pm, this.getPersistenceManagerFactory());
        }
    }
}

