/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapExecutor;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.client.event.RowHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springframework.orm.ibatis.SqlMapClientCallback;
import org.springframework.orm.ibatis.SqlMapClientOperations;

public class SqlMapClientTemplate
extends JdbcAccessor
implements SqlMapClientOperations {
    private SqlMapClient sqlMapClient;

    public SqlMapClientTemplate() {
    }

    public SqlMapClientTemplate(DataSource dataSource, SqlMapClient sqlMapClient) {
        this.setDataSource(dataSource);
        this.sqlMapClient = sqlMapClient;
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public SqlMapClient getSqlMapClient() {
        return this.sqlMapClient;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.sqlMapClient == null) {
            throw new IllegalArgumentException("sqlMapClient is required");
        }
    }

    public Object execute(SqlMapClientCallback action) throws DataAccessException {
        SqlMapSession session = this.sqlMapClient.openSession();
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        try {
            session.setUserConnection(con);
            Object object = action.doInSqlMapClient((SqlMapExecutor)session);
            return object;
        }
        catch (SQLException ex) {
            throw this.getExceptionTranslator().translate("SqlMapClientTemplate", "(mapped statement)", ex);
        }
        finally {
            DataSourceUtils.closeConnectionIfNecessary(con, this.getDataSource());
            session.close();
        }
    }

    public List executeWithListResult(SqlMapClientCallback action) throws DataAccessException {
        return (List)this.execute(action);
    }

    public Map executeWithMapResult(SqlMapClientCallback action) throws DataAccessException {
        return (Map)this.execute(action);
    }

    public Object queryForObject(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForObject(statementName, parameterObject);
            }
        });
    }

    public Object queryForObject(final String statementName, final Object parameterObject, final Object resultObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForObject(statementName, parameterObject, resultObject);
            }
        });
    }

    public List queryForList(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.executeWithListResult(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForList(statementName, parameterObject);
            }
        });
    }

    public List queryForList(final String statementName, final Object parameterObject, final int skipResults, final int maxResults) throws DataAccessException {
        return this.executeWithListResult(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForList(statementName, parameterObject, skipResults, maxResults);
            }
        });
    }

    public List queryForList(final String statementName, final Object parameterObject, final RowHandler rowHandler) throws DataAccessException {
        return this.executeWithListResult(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForList(statementName, parameterObject, rowHandler);
            }
        });
    }

    public Map queryForMap(final String statementName, final Object parameterObject, final String keyProperty) throws DataAccessException {
        return this.executeWithMapResult(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForMap(statementName, parameterObject, keyProperty);
            }
        });
    }

    public Map queryForMap(final String statementName, final Object parameterObject, final String keyProperty, final String valueProperty) throws DataAccessException {
        return this.executeWithMapResult(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForMap(statementName, parameterObject, keyProperty, valueProperty);
            }
        });
    }

    public Object insert(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.insert(statementName, parameterObject);
            }
        });
    }

    public int update(final String statementName, final Object parameterObject) throws DataAccessException {
        Integer result = (Integer)this.execute(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return new Integer(executor.update(statementName, parameterObject));
            }
        });
        return result;
    }

    public int delete(final String statementName, final Object parameterObject) throws DataAccessException {
        Integer result = (Integer)this.execute(new SqlMapClientCallback(){

            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return new Integer(executor.delete(statementName, parameterObject));
            }
        });
        return result;
    }
}

