/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.util.HashSet;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.IntroductionAdvisor;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.springframework.core.Ordered;

public class DefaultIntroductionAdvisor
implements IntroductionAdvisor,
ClassFilter,
Ordered {
    private int order = Integer.MAX_VALUE;
    private IntroductionInterceptor interceptor;
    private Set interfaces = new HashSet();

    public DefaultIntroductionAdvisor(IntroductionInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public DefaultIntroductionAdvisor(IntroductionInterceptor interceptor, Class clazz) throws AopConfigException {
        this(interceptor);
        this.addInterface(clazz);
    }

    public DefaultIntroductionAdvisor(DelegatingIntroductionInterceptor dii) {
        this((IntroductionInterceptor)dii);
        for (int i = 0; i < dii.getIntroducedInterfaces().length; ++i) {
            Class intf = dii.getIntroducedInterfaces()[i];
            this.addInterface(intf);
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void addInterface(Class intf) throws AopConfigException {
        this.interfaces.add(intf);
    }

    public ClassFilter getClassFilter() {
        return this;
    }

    public Advice getAdvice() {
        return this.interceptor;
    }

    public Class[] getInterfaces() {
        return this.interfaces.toArray(new Class[this.interfaces.size()]);
    }

    public boolean matches(Class clazz) {
        return true;
    }

    public boolean isPerInstance() {
        return true;
    }

    public void validateInterfaces() throws AopConfigException {
        for (int i = 0; i < this.getInterfaces().length; ++i) {
            if (!this.getInterfaces()[i].isInterface()) {
                throw new AopConfigException("Class '" + this.getInterfaces()[i].getName() + "' is not an interface; cannot be used in an introduction");
            }
            if (this.interceptor.implementsInterface(this.getInterfaces()[i])) continue;
            throw new AopConfigException("IntroductionInterceptor [" + this.interceptor + "] " + "does not implement interface '" + this.getInterfaces()[i].getName() + "' specified in introduction advice");
        }
    }
}

