/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.util.StringUtils;

class FilterConfigPropertyValues
implements PropertyValues {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private MutablePropertyValues mutablePropertyValues;

    public FilterConfigPropertyValues(FilterConfig config) throws ServletException {
        this(config, null);
    }

    public FilterConfigPropertyValues(FilterConfig config, List requiredProperties) throws ServletException {
        ArrayList missingProps = requiredProperties == null ? new ArrayList(0) : new ArrayList(requiredProperties);
        this.mutablePropertyValues = new MutablePropertyValues();
        Enumeration enumeration = config.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String property = (String)enumeration.nextElement();
            String value = config.getInitParameter(property);
            this.mutablePropertyValues.addPropertyValue(new PropertyValue(property, value));
            missingProps.remove(property);
        }
        if (missingProps.size() > 0) {
            throw new ServletException("Initialization from ServletConfig for servlet '" + config.getFilterName() + "' failed: the following required properties were missing -- (" + StringUtils.collectionToDelimitedString(missingProps, ", ") + ")");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found PropertyValues in ServletConfig: " + this.mutablePropertyValues));
        }
    }

    public PropertyValue[] getPropertyValues() {
        return this.mutablePropertyValues.getPropertyValues();
    }

    public boolean contains(String propertyName) {
        return this.mutablePropertyValues.contains(propertyName);
    }

    public PropertyValue getPropertyValue(String propertyName) {
        return this.mutablePropertyValues.getPropertyValue(propertyName);
    }

    public PropertyValues changesSince(PropertyValues old) {
        return this.mutablePropertyValues.changesSince(old);
    }
}

