/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import javax.jdo.JDOException;
import javax.jdo.JDOFatalException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.orm.jdo.JdoDialect;
import org.springframework.orm.jdo.JdoTransactionObject;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.orm.jdo.PersistenceManagerHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.InvalidTimeoutException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JdoTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean {
    private PersistenceManagerFactory persistenceManagerFactory;
    private DataSource dataSource;
    private JdoDialect jdoDialect;

    public JdoTransactionManager() {
    }

    public JdoTransactionManager(PersistenceManagerFactory pmf) {
        this.persistenceManagerFactory = pmf;
        this.afterPropertiesSet();
    }

    public void setPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        this.persistenceManagerFactory = pmf;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setJdoDialect(JdoDialect jdoDialect) {
        this.jdoDialect = jdoDialect;
    }

    public JdoDialect getJdoDialect() {
        return this.jdoDialect;
    }

    public void afterPropertiesSet() {
        if (this.persistenceManagerFactory == null) {
            throw new IllegalArgumentException("persistenceManagerFactory is required");
        }
        if (this.dataSource != null && this.jdoDialect == null) {
            throw new IllegalArgumentException("A jdoDialect is required to expose JDO transactions as JDBC transactions");
        }
    }

    protected Object doGetTransaction() {
        if (TransactionSynchronizationManager.hasResource(this.persistenceManagerFactory)) {
            this.logger.debug((Object)"Found thread-bound persistence manager for JDO transaction");
            PersistenceManagerHolder pmHolder = (PersistenceManagerHolder)TransactionSynchronizationManager.getResource(this.persistenceManagerFactory);
            return new JdoTransactionObject(pmHolder);
        }
        return new JdoTransactionObject();
    }

    protected boolean isExistingTransaction(Object transaction) {
        return ((JdoTransactionObject)transaction).hasTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        PersistenceManager pm;
        JdoTransactionObject txObject;
        if (definition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException("JdoTransactionManager does not support custom isolation levels");
        }
        if (definition.getTimeout() != -1) {
            throw new InvalidTimeoutException("JdoTransactionManager does not support timeouts", definition.getTimeout());
        }
        if (definition.isReadOnly()) {
            this.logger.warn((Object)"JdoTransactionManager does not support read-only transactions: ignoring 'readOnly' hint");
        }
        if ((txObject = (JdoTransactionObject)transaction).getPersistenceManagerHolder() == null) {
            this.logger.debug((Object)"Opening new persistence manager for JDO transaction");
            pm = PersistenceManagerFactoryUtils.getPersistenceManager(this.persistenceManagerFactory, true, false);
            txObject.setPersistenceManagerHolder(new PersistenceManagerHolder(pm));
        }
        this.logger.debug((Object)"Beginning JDO transaction");
        try {
            pm = txObject.getPersistenceManagerHolder().getPersistenceManager();
            pm.currentTransaction().begin();
            if (txObject.isNewPersistenceManagerHolder()) {
                TransactionSynchronizationManager.bindResource(this.persistenceManagerFactory, txObject.getPersistenceManagerHolder());
            }
            if (this.dataSource != null && this.jdoDialect != null) {
                ConnectionHolder conHolder = new ConnectionHolder(this.jdoDialect.getJdbcConnection(pm));
                if (definition.getTimeout() != -1) {
                    conHolder.setTimeoutInSeconds(definition.getTimeout());
                }
                TransactionSynchronizationManager.bindResource(this.dataSource, conHolder);
            }
        }
        catch (JDOException ex) {
            throw new CannotCreateTransactionException("Could not create JDO transaction", ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        JdoTransactionObject txObject = (JdoTransactionObject)transaction;
        txObject.setPersistenceManagerHolder(null);
        PersistenceManagerHolder persistenceManagerHolder = (PersistenceManagerHolder)TransactionSynchronizationManager.unbindResource(this.persistenceManagerFactory);
        ConnectionHolder connectionHolder = null;
        if (this.dataSource != null) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource(this.dataSource);
        }
        return new SuspendedResourcesHolder(persistenceManagerHolder, connectionHolder);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        TransactionSynchronizationManager.bindResource(this.persistenceManagerFactory, resourcesHolder.getPersistenceManagerHolder());
        if (this.dataSource != null) {
            TransactionSynchronizationManager.bindResource(this.dataSource, resourcesHolder.getConnectionHolder());
        }
    }

    protected boolean isRollbackOnly(Object transaction) {
        return ((JdoTransactionObject)transaction).getPersistenceManagerHolder().isRollbackOnly();
    }

    protected void doCommit(DefaultTransactionStatus status) {
        JdoTransactionObject txObject = (JdoTransactionObject)status.getTransaction();
        this.logger.debug((Object)"Committing JDO transaction");
        try {
            txObject.getPersistenceManagerHolder().getPersistenceManager().currentTransaction().commit();
        }
        catch (JDOFatalException ex) {
            throw new TransactionSystemException("Could not commit JDO transaction", ex);
        }
        catch (JDOException ex) {
            throw this.convertJdoAccessException(ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        JdoTransactionObject txObject = (JdoTransactionObject)status.getTransaction();
        this.logger.debug((Object)"Rolling back JDO transaction");
        try {
            txObject.getPersistenceManagerHolder().getPersistenceManager().currentTransaction().rollback();
        }
        catch (JDOException ex) {
            throw new TransactionSystemException("Could not rollback JDO transaction", ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        JdoTransactionObject txObject = (JdoTransactionObject)status.getTransaction();
        this.logger.debug((Object)"Setting JDO transaction rollback-only");
        txObject.getPersistenceManagerHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        JdoTransactionObject txObject = (JdoTransactionObject)transaction;
        if (this.dataSource != null) {
            TransactionSynchronizationManager.unbindResource(this.dataSource);
        }
        if (txObject.isNewPersistenceManagerHolder()) {
            TransactionSynchronizationManager.unbindResource(this.persistenceManagerFactory);
            try {
                PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(txObject.getPersistenceManagerHolder().getPersistenceManager(), this.persistenceManagerFactory);
            }
            catch (CleanupFailureDataAccessException ex) {
                this.logger.error((Object)"Could not close JDO persistence manager after transaction", (Throwable)ex);
            }
        } else {
            this.logger.debug((Object)"Not closing pre-bound JDO persistence manager after transaction");
        }
    }

    protected DataAccessException convertJdoAccessException(JDOException ex) {
        if (this.jdoDialect != null) {
            return this.jdoDialect.translateException(ex);
        }
        return PersistenceManagerFactoryUtils.convertJdoAccessException(ex);
    }

    private static class SuspendedResourcesHolder {
        private final PersistenceManagerHolder persistenceManagerHolder;
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(PersistenceManagerHolder persistenceManagerHolder, ConnectionHolder connectionHolder) {
            this.persistenceManagerHolder = persistenceManagerHolder;
            this.connectionHolder = connectionHolder;
        }

        private PersistenceManagerHolder getPersistenceManagerHolder() {
            return this.persistenceManagerHolder;
        }

        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }
}

