/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ResourceEntityResolver;

public abstract class AbstractXmlApplicationContext
extends AbstractApplicationContext {
    private ConfigurableListableBeanFactory beanFactory;

    public AbstractXmlApplicationContext() {
    }

    public AbstractXmlApplicationContext(ApplicationContext parent) {
        super(parent);
    }

    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected void refreshBeanFactory() throws BeansException {
        try {
            DefaultListableBeanFactory beanFactory = new DefaultListableBeanFactory(this.getParent());
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(beanFactory);
            reader.setEntityResolver(new ResourceEntityResolver(this));
            this.loadBeanDefinitions(reader);
            this.beanFactory = beanFactory;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Bean factory for application context: " + beanFactory));
            }
        }
        catch (IOException ex) {
            throw new ApplicationContextException("I/O error parsing XML document for application context [" + this.getDisplayName() + "]", ex);
        }
    }

    protected abstract void loadBeanDefinitions(XmlBeanDefinitionReader var1) throws BeansException, IOException;
}

