/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class PropertiesFactoryBean
implements FactoryBean,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Properties properties;
    private Resource[] locations;
    private boolean singleton = true;
    private Properties singletonInstance;
    static /* synthetic */ Class class$java$util$Properties;

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setLocation(Resource location) {
        this.locations = new Resource[]{location};
    }

    public void setLocations(Resource[] locations) {
        this.locations = locations;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void afterPropertiesSet() throws IOException {
        if (this.properties == null && this.locations == null) {
            throw new IllegalArgumentException("Either properties or location(s) must be set");
        }
        if (this.singleton) {
            this.singletonInstance = this.mergeProperties();
        }
    }

    public Object getObject() throws IOException {
        if (this.singleton) {
            return this.singletonInstance;
        }
        return this.mergeProperties();
    }

    protected Properties mergeProperties() throws IOException {
        Properties result = new Properties();
        if (this.properties != null) {
            result.putAll((Map<?, ?>)this.properties);
        }
        if (this.locations != null) {
            result.putAll((Map<?, ?>)this.loadProperties());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties() throws IOException {
        Properties props = new Properties();
        for (int i = 0; i < this.locations.length; ++i) {
            Resource location = this.locations[i];
            this.logger.info((Object)("Loading props file from " + location));
            InputStream is = location.getInputStream();
            try {
                props.load(is);
                continue;
            }
            finally {
                is.close();
            }
        }
        return props;
    }

    public Class getObjectType() {
        return class$java$util$Properties == null ? (class$java$util$Properties = PropertiesFactoryBean.class$("java.util.Properties")) : class$java$util$Properties;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

