/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.access;

import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.access.BootstrapException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jndi.JndiTemplate;
import org.springframework.util.StringUtils;

public class SimpleJndiBeanFactoryLocator
implements BeanFactoryLocator {
    public static final String BEAN_FACTORY_PATH_DELIMITERS = ",; ";
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$factory$access$SimpleJndiBeanFactoryLocator == null ? (class$org$springframework$beans$factory$access$SimpleJndiBeanFactoryLocator = SimpleJndiBeanFactoryLocator.class$("org.springframework.beans.factory.access.SimpleJndiBeanFactoryLocator")) : class$org$springframework$beans$factory$access$SimpleJndiBeanFactoryLocator));
    static /* synthetic */ Class class$org$springframework$beans$factory$access$SimpleJndiBeanFactoryLocator;

    public BeanFactoryReference useFactory(String factoryKey) throws BootstrapException {
        String beanFactoryPath = null;
        try {
            beanFactoryPath = (String)new JndiTemplate().lookup(factoryKey);
            logger.info((Object)("BeanFactoryPath from JNDI is [" + beanFactoryPath + "]"));
            String[] paths = StringUtils.tokenizeToStringArray(beanFactoryPath, BEAN_FACTORY_PATH_DELIMITERS, true, true);
            final BeanFactory beanFactory = this.createFactory(paths);
            logger.info((Object)("Loaded BeanFactory [" + beanFactory + "]"));
            return new BeanFactoryReference(){

                public BeanFactory getFactory() {
                    return beanFactory;
                }

                public void release() throws FatalBeanException {
                }
            };
        }
        catch (NamingException ex) {
            throw new BootstrapException("Define an environment variable 'ejb/BeanFactoryPath' containing the location on the class path of an XmlBeanFactory" + ex.getMessage(), ex);
        }
        catch (BeanDefinitionStoreException ex) {
            throw new BootstrapException("Found resource at '" + beanFactoryPath + "' but it's not a valid Spring bean definition XML file: " + ex.getMessage(), null);
        }
    }

    protected BeanFactory createFactory(String[] resources) throws FatalBeanException {
        DefaultListableBeanFactory fac = new DefaultListableBeanFactory();
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(fac);
        for (int i = 0; i < resources.length; ++i) {
            reader.loadBeanDefinitions(new ClassPathResource(resources[i]));
        }
        fac.preInstantiateSingletons();
        return fac;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

