/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class InternalResourceView
extends AbstractUrlBasedView {
    public InternalResourceView() {
    }

    public InternalResourceView(String url) {
        this.setUrl(url);
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeModelAsRequestAttributes(model, request);
        RequestDispatcher rd = request.getRequestDispatcher(this.getUrl());
        if (rd == null) {
            throw new ServletException("Can't get RequestDispatcher for [" + this.getUrl() + "']: check that this file exists within your WAR");
        }
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            rd.include((ServletRequest)request, (ServletResponse)response);
            this.logger.debug((Object)("Included resource [" + this.getUrl() + "] in InternalResourceView '" + this.getName() + "'"));
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
            this.logger.debug((Object)("Forwarded to resource [" + this.getUrl() + "] in InternalResourceView '" + this.getName() + "'"));
        }
    }

    protected void exposeModelAsRequestAttributes(Map model, HttpServletRequest request) throws ServletException {
        if (model != null) {
            Iterator itr = model.keySet().iterator();
            while (itr.hasNext()) {
                Object key = itr.next();
                if (!(key instanceof String)) {
                    throw new ServletException("Invalid key [" + key + "] in model Map - only Strings allowed as model keys");
                }
                String modelName = (String)key;
                Object modelValue = model.get(modelName);
                if (modelValue == null) continue;
                request.setAttribute(modelName, modelValue);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added model object '" + modelName + "' of type [" + modelValue.getClass().getName() + "] to request in InternalResourceView '" + this.getName() + "' "));
            }
        } else {
            this.logger.debug((Object)"Model is null. Nothing to expose to request.");
        }
    }
}

