/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.core.OrderComparator;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.ModelAndViewDefiningException;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;
import org.springframework.web.servlet.mvc.throwaway.ThrowawayControllerHandlerAdapter;
import org.springframework.web.servlet.mvc.throwaway.ValidatableThrowawayControllerHandlerAdapter;
import org.springframework.web.servlet.theme.FixedThemeResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.util.WebUtils;

public class DispatcherServlet
extends FrameworkServlet {
    public static final String MULTIPART_RESOLVER_BEAN_NAME = "multipartResolver";
    public static final String LOCALE_RESOLVER_BEAN_NAME = "localeResolver";
    public static final String THEME_RESOLVER_BEAN_NAME = "themeResolver";
    public static final String EXCEPTION_RESOLVER_BEAN_NAME = "exceptionResolver";
    public static final String VIEW_RESOLVER_BEAN_NAME = "viewResolver";
    public static final String WEB_APPLICATION_CONTEXT_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".CONTEXT";
    public static final String LOCALE_RESOLVER_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".LOCALE";
    public static final String MULTIPART_RESOLVER_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".MULTIPART";
    public static final String THEME_RESOLVER_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".THEME";
    protected final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private MultipartResolver multipartResolver;
    private LocaleResolver localeResolver;
    private ThemeResolver themeResolver;
    private List handlerMappings;
    private List handlerAdapters;
    private List handlerExceptionResolvers;
    private ViewResolver viewResolver;
    static /* synthetic */ Class class$org$springframework$web$servlet$DispatcherServlet;
    static /* synthetic */ Class class$org$springframework$web$servlet$HandlerMapping;
    static /* synthetic */ Class class$org$springframework$web$servlet$HandlerAdapter;
    static /* synthetic */ Class class$org$springframework$web$servlet$HandlerExceptionResolver;

    protected void initFrameworkServlet() throws ServletException, BeansException {
        this.initMultipartResolver();
        this.initLocaleResolver();
        this.initThemeResolver();
        this.initHandlerMappings();
        this.initHandlerAdapters();
        this.initHandlerExceptionResolvers();
        this.initViewResolver();
    }

    private void initMultipartResolver() throws BeansException {
        try {
            this.multipartResolver = (MultipartResolver)this.getWebApplicationContext().getBean(MULTIPART_RESOLVER_BEAN_NAME);
            this.logger.info((Object)("Loaded multipart resolver [" + this.multipartResolver + "]"));
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.multipartResolver = null;
            this.logger.info((Object)"Unable to locate multipart resolver with name [multipartResolver]: no multipart handling provided");
        }
    }

    private void initLocaleResolver() throws BeansException {
        try {
            this.localeResolver = (LocaleResolver)this.getWebApplicationContext().getBean(LOCALE_RESOLVER_BEAN_NAME);
            this.logger.info((Object)("Loaded locale resolver [" + this.localeResolver + "]"));
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.localeResolver = new AcceptHeaderLocaleResolver();
            this.logger.info((Object)("Unable to locate locale resolver with name 'localeResolver': using default [" + this.localeResolver + "]"));
        }
    }

    private void initThemeResolver() throws BeansException {
        try {
            this.themeResolver = (ThemeResolver)this.getWebApplicationContext().getBean(THEME_RESOLVER_BEAN_NAME);
            this.logger.info((Object)("Loaded theme resolver [" + this.themeResolver + "]"));
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.themeResolver = new FixedThemeResolver();
            this.logger.info((Object)("Unable to locate theme resolver with name 'themeResolver': using default [" + this.themeResolver + "]"));
        }
    }

    private void initHandlerMappings() throws BeansException {
        Map matchingBeans = this.getWebApplicationContext().getBeansOfType(class$org$springframework$web$servlet$HandlerMapping == null ? (class$org$springframework$web$servlet$HandlerMapping = DispatcherServlet.class$("org.springframework.web.servlet.HandlerMapping")) : class$org$springframework$web$servlet$HandlerMapping, true, false);
        this.handlerMappings = new ArrayList(matchingBeans.values());
        if (this.handlerMappings.isEmpty()) {
            BeanNameUrlHandlerMapping hm = new BeanNameUrlHandlerMapping();
            hm.setApplicationContext(this.getWebApplicationContext());
            this.handlerMappings.add(hm);
            this.logger.info((Object)("No HandlerMappings found in servlet '" + this.getServletName() + "': using default"));
        } else {
            Collections.sort(this.handlerMappings, new OrderComparator());
        }
    }

    private void initHandlerAdapters() throws BeansException {
        Map matchingBeans = this.getWebApplicationContext().getBeansOfType(class$org$springframework$web$servlet$HandlerAdapter == null ? (class$org$springframework$web$servlet$HandlerAdapter = DispatcherServlet.class$("org.springframework.web.servlet.HandlerAdapter")) : class$org$springframework$web$servlet$HandlerAdapter, true, false);
        this.handlerAdapters = new ArrayList(matchingBeans.values());
        if (this.handlerAdapters.isEmpty()) {
            this.handlerAdapters.add(new SimpleControllerHandlerAdapter());
            this.handlerAdapters.add(new ThrowawayControllerHandlerAdapter());
            this.handlerAdapters.add(new ValidatableThrowawayControllerHandlerAdapter());
            this.logger.info((Object)("No HandlerAdapters found in servlet '" + this.getServletName() + "': using defaults"));
        } else {
            Collections.sort(this.handlerAdapters, new OrderComparator());
        }
    }

    private void initHandlerExceptionResolvers() throws BeansException {
        Map matchingBeans = this.getWebApplicationContext().getBeansOfType(class$org$springframework$web$servlet$HandlerExceptionResolver == null ? (class$org$springframework$web$servlet$HandlerExceptionResolver = DispatcherServlet.class$("org.springframework.web.servlet.HandlerExceptionResolver")) : class$org$springframework$web$servlet$HandlerExceptionResolver, true, false);
        this.handlerExceptionResolvers = new ArrayList(matchingBeans.values());
        Collections.sort(this.handlerExceptionResolvers, new OrderComparator());
    }

    private void initViewResolver() throws BeansException {
        try {
            this.viewResolver = (ViewResolver)this.getWebApplicationContext().getBean(VIEW_RESOLVER_BEAN_NAME);
            this.logger.info((Object)("Loaded view resolver [" + this.viewResolver + "]"));
        }
        catch (NoSuchBeanDefinitionException ex) {
            InternalResourceViewResolver vr = new InternalResourceViewResolver();
            vr.setApplicationContext(this.getWebApplicationContext());
            this.viewResolver = vr;
            this.logger.info((Object)("Unable to locate view resolver with name 'viewResolver': using default [" + this.viewResolver + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block19: {
            this.logger.debug((Object)("DispatcherServlet with name '" + this.getServletName() + "' received request for [" + WebUtils.getRequestUri(request) + "]"));
            request.setAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.getWebApplicationContext());
            request.setAttribute(DispatcherServlet.LOCALE_RESOLVER_ATTRIBUTE, (Object)this.localeResolver);
            request.setAttribute(DispatcherServlet.THEME_RESOLVER_ATTRIBUTE, (Object)this.themeResolver);
            processedRequest = request;
            if (this.multipartResolver != null && this.multipartResolver.isMultipart(request)) {
                if (request instanceof MultipartHttpServletRequest) {
                    throw new ServletException("Request is already a MultipartHttpServletRequest - have you registered both a MultipartFilter and a 'multipartResolver' bean for this DispatcherServlet?");
                }
                request.setAttribute(DispatcherServlet.MULTIPART_RESOLVER_ATTRIBUTE, (Object)this.multipartResolver);
                processedRequest = this.multipartResolver.resolveMultipart(request);
            }
            mappedHandler = null;
            interceptorIndex = -1;
            try {
                try {
                    block21: {
                        block20: {
                            mappedHandler = this.getHandler(processedRequest);
                            if (mappedHandler == null || mappedHandler.getHandler() == null) {
                                this.pageNotFoundLogger.warn((Object)("No mapping for [" + WebUtils.getRequestUri(processedRequest) + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
                                response.sendError(404);
                                var11_6 = null;
                                if (this.multipartResolver == null) return;
                                break block19;
                            }
                            mv = null;
                            try {
                                if (mappedHandler.getInterceptors() == null) ** GOTO lbl57
                                i = 0;
lbl27:
                                // 2 sources

                                while (i < mappedHandler.getInterceptors().length) {
                                    interceptor = mappedHandler.getInterceptors()[i];
                                    if (!interceptor.preHandle(processedRequest, response, mappedHandler.getHandler())) {
                                        break block20;
                                    }
                                    ** GOTO lbl-1000
                                }
                                ** GOTO lbl57
                            }
                            catch (ModelAndViewDefiningException ex) {
                                this.logger.debug((Object)"ModelAndViewDefiningException encountered", (Throwable)ex);
                                mv = ex.getModelAndView();
                                break block21;
                            }
                            catch (Exception ex) {
                                exMv = null;
                                it = this.handlerExceptionResolvers.iterator();
                                while (exMv == null && it.hasNext()) {
                                    exMv = ((HandlerExceptionResolver)it.next()).resolveException(ex, mappedHandler.getHandler());
                                }
                                if (exMv == null) throw ex;
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug((Object)("HandlerExceptionResolver returned ModelAndView [" + exMv + "] for exception"));
                                }
                                this.logger.warn((Object)"Handler execution resulted in exception - forwarding to resolved error view", (Throwable)ex);
                                mv = exMv;
                                break block21;
                            }
                        }
                        var11_7 = null;
                        if (this.multipartResolver == null) return;
                        if (processedRequest instanceof MultipartHttpServletRequest == false) return;
                        this.multipartResolver.cleanupMultipart((MultipartHttpServletRequest)processedRequest);
                        return;
lbl-1000:
                        // 1 sources

                        {
                            interceptorIndex = i++;
                            ** GOTO lbl27
lbl57:
                            // 2 sources

                            ha = this.getHandlerAdapter(mappedHandler.getHandler());
                            mv = ha.handle(processedRequest, response, mappedHandler.getHandler());
                            if (mappedHandler.getInterceptors() == null) break block21;
                            for (i = mappedHandler.getInterceptors().length - 1; i >= 0; --i) {
                                interceptor = mappedHandler.getInterceptors()[i];
                                interceptor.postHandle(processedRequest, response, mappedHandler.getHandler(), mv);
                            }
                        }
                    }
                    if (mv != null) {
                        this.logger.debug((Object)("Will render view in DispatcherServlet with name '" + this.getServletName() + "'"));
                        locale = this.localeResolver.resolveLocale(processedRequest);
                        response.setLocale(locale);
                        this.render(mv, processedRequest, response, locale);
                    } else {
                        this.logger.debug((Object)("Null ModelAndView returned to DispatcherServlet with name '" + this.getServletName() + "': assuming HandlerAdapter completed request handling"));
                    }
                    this.triggerAfterCompletion(mappedHandler, interceptorIndex, processedRequest, response, null);
                }
                catch (Exception ex) {
                    if (mappedHandler != null) {
                        this.triggerAfterCompletion(mappedHandler, interceptorIndex, processedRequest, response, ex);
                    }
                    var11_9 = null;
                    if (this.multipartResolver == null) return;
                    if (processedRequest instanceof MultipartHttpServletRequest == false) return;
                    this.multipartResolver.cleanupMultipart((MultipartHttpServletRequest)processedRequest);
                    return;
                }
                var11_8 = null;
                if (this.multipartResolver == null) return;
                if (processedRequest instanceof MultipartHttpServletRequest == false) return;
                this.multipartResolver.cleanupMultipart((MultipartHttpServletRequest)processedRequest);
                return;
            }
            catch (Throwable var10_21) {
                var11_10 = null;
                if (this.multipartResolver == null) throw var10_21;
                if (processedRequest instanceof MultipartHttpServletRequest == false) throw var10_21;
                this.multipartResolver.cleanupMultipart((MultipartHttpServletRequest)processedRequest);
                throw var10_21;
            }
        }
        if (processedRequest instanceof MultipartHttpServletRequest == false) return;
        this.multipartResolver.cleanupMultipart((MultipartHttpServletRequest)processedRequest);
    }

    protected long getLastModified(HttpServletRequest request) {
        try {
            HandlerExecutionChain mappedHandler = this.getHandler(request);
            if (mappedHandler == null || mappedHandler.getHandler() == null) {
                this.logger.debug((Object)"No handler found in getLastModified");
                return -1L;
            }
            HandlerAdapter ha = this.getHandlerAdapter(mappedHandler.getHandler());
            long lastModified = ha.getLastModified(request, mappedHandler.getHandler());
            this.logger.debug((Object)("Last-Modified value for [" + WebUtils.getRequestUri(request) + "] is [" + lastModified + "]"));
            return lastModified;
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Exception thrown in getLastModified", (Throwable)ex);
            return -1L;
        }
    }

    private HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        Iterator itr = this.handlerMappings.iterator();
        while (itr.hasNext()) {
            HandlerMapping hm = (HandlerMapping)itr.next();
            this.logger.debug((Object)("Testing handler map [" + hm + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
            HandlerExecutionChain handler = hm.getHandler(request);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    private HandlerAdapter getHandlerAdapter(Object handler) throws ServletException {
        Iterator itr = this.handlerAdapters.iterator();
        while (itr.hasNext()) {
            HandlerAdapter ha = (HandlerAdapter)itr.next();
            this.logger.debug((Object)("Testing handler adapter [" + ha + "]"));
            if (!ha.supports(handler)) continue;
            return ha;
        }
        throw new ServletException("No adapter for handler [" + handler + "]");
    }

    private void render(ModelAndView mv, HttpServletRequest request, HttpServletResponse response, Locale locale) throws Exception {
        View view = null;
        view = mv.isReference() ? this.viewResolver.resolveViewName(mv.getViewName(), locale) : mv.getView();
        if (view == null) {
            throw new ServletException("Error in ModelAndView object or View resolution encountered by servlet with name '" + this.getServletName() + "': View to render cannot be null with ModelAndView [" + mv + "]");
        }
        view.render(mv.getModel(), request, response);
    }

    private void triggerAfterCompletion(HandlerExecutionChain mappedHandler, int interceptorIndex, HttpServletRequest request, HttpServletResponse response, Exception ex) throws Exception {
        Exception currEx = ex;
        if (mappedHandler.getInterceptors() != null) {
            for (int i = interceptorIndex; i >= 0; --i) {
                HandlerInterceptor interceptor = mappedHandler.getInterceptors()[i];
                try {
                    interceptor.afterCompletion(request, response, mappedHandler.getHandler(), ex);
                    continue;
                }
                catch (Exception ex2) {
                    if (currEx != null) {
                        this.logger.error((Object)"Exception overridden by HandlerInterceptor.afterCompletion exception", (Throwable)currEx);
                    }
                    currEx = ex2;
                }
            }
        }
        if (currEx != null) {
            throw currEx;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

