/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.io.IOException;
import javax.servlet.ServletContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.Resource;
import org.springframework.ui.context.support.AbstractXmlUiApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.util.ServletContextResource;

public class XmlWebApplicationContext
extends AbstractXmlUiApplicationContext
implements ConfigurableWebApplicationContext {
    public static final String DEFAULT_CONFIG_LOCATION = "/WEB-INF/applicationContext.xml";
    public static final String DEFAULT_CONFIG_LOCATION_PREFIX = "/WEB-INF/";
    public static final String DEFAULT_CONFIG_LOCATION_SUFFIX = ".xml";
    private ServletContext servletContext;
    private String namespace = null;
    private String[] configLocations;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    protected String getNamespace() {
        return this.namespace;
    }

    public void setConfigLocations(String[] configLocations) {
        this.configLocations = configLocations;
    }

    protected String[] getConfigLocations() {
        return this.configLocations;
    }

    public void refresh() throws BeansException {
        if (this.namespace != null) {
            this.setDisplayName("XmlWebApplicationContext for namespace '" + this.namespace + "'");
            if (this.configLocations == null || this.configLocations.length == 0) {
                this.configLocations = new String[]{DEFAULT_CONFIG_LOCATION_PREFIX + this.namespace + DEFAULT_CONFIG_LOCATION_SUFFIX};
            }
        } else {
            this.setDisplayName("Root XmlWebApplicationContext");
            if (this.configLocations == null || this.configLocations.length == 0) {
                this.configLocations = new String[]{DEFAULT_CONFIG_LOCATION};
            }
        }
        super.refresh();
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        for (int i = 0; i < this.configLocations.length; ++i) {
            reader.loadBeanDefinitions(this.getResource(this.configLocations[i]));
        }
    }

    protected Resource getResourceByPath(String path) throws IOException {
        if (path != null && !path.startsWith("/")) {
            path = "/" + path;
        }
        return new ServletContextResource(this.servletContext, path);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString() + "; ");
        sb.append("config locations=[" + StringUtils.arrayToCommaDelimitedString(this.configLocations) + "]; ");
        return sb.toString();
    }
}

