/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.ServletRequestBindingException;

public abstract class RequestUtils {
    public static void rejectRequestMethod(HttpServletRequest request, String method) throws ServletException {
        if (request.getMethod().equals(method)) {
            throw new ServletException("This resource does not support request method '" + method + "'");
        }
    }

    public static int getIntParameter(HttpServletRequest request, String name, int defaultVal) {
        try {
            return RequestUtils.getRequiredIntParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static int getRequiredIntParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        String s = request.getParameter(name);
        if (s == null) {
            throw new ServletRequestBindingException("Required int parameter '" + name + "' was not supplied");
        }
        if ("".equals(s)) {
            throw new ServletRequestBindingException("Required int parameter '" + name + "' contained no value");
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            throw new ServletRequestBindingException("Required int parameter '" + name + "' value of '" + s + "' was not a valid number");
        }
    }

    public static long getLongParameter(HttpServletRequest request, String name, long defaultVal) {
        try {
            return RequestUtils.getRequiredLongParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static long getRequiredLongParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        String s = request.getParameter(name);
        if (s == null) {
            throw new ServletRequestBindingException("Required long parameter '" + name + "' was not supplied");
        }
        if ("".equals(s)) {
            throw new ServletRequestBindingException("Required long parameter '" + name + "' contained no value");
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            throw new ServletRequestBindingException("Required long parameter '" + name + "' value of '" + s + "' was not a valid number");
        }
    }

    public static double getDoubleParameter(HttpServletRequest request, String name, double defaultVal) {
        try {
            return RequestUtils.getRequiredDoubleParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static double getRequiredDoubleParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        String s = request.getParameter(name);
        if (s == null) {
            throw new ServletRequestBindingException("Required double parameter '" + name + "' was not supplied");
        }
        if ("".equals(s)) {
            throw new ServletRequestBindingException("Required double parameter '" + name + "' contained no value");
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException ex) {
            throw new ServletRequestBindingException("Required double parameter '" + name + "' value of '" + s + "' was not a valid number");
        }
    }

    public static boolean getBooleanParameter(HttpServletRequest request, String name, boolean defaultVal) {
        try {
            return RequestUtils.getRequiredBooleanParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static boolean getRequiredBooleanParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        String s = request.getParameter(name);
        if (s == null) {
            throw new ServletRequestBindingException("Required boolean parameter '" + name + "' was not supplied");
        }
        if ("".equals(s)) {
            throw new ServletRequestBindingException("Required boolean parameter '" + name + "' contained no value");
        }
        return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equals("1");
    }

    public static String getStringParameter(HttpServletRequest request, String name, String defaultVal) {
        try {
            return RequestUtils.getRequiredStringParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static String getRequiredStringParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        String s = request.getParameter(name);
        if (s == null) {
            throw new ServletRequestBindingException("Required string parameter '" + name + "' was not supplied");
        }
        if ("".equals(s)) {
            throw new ServletRequestBindingException("Required string parameter '" + name + "' contained no value");
        }
        return s;
    }
}

