/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.MutableSortDefinition;
import org.springframework.beans.PropertyComparator;
import org.springframework.beans.SortDefinition;

public class PagedListHolder
implements Serializable {
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int DEFAULT_MAX_LINKED_PAGES = 10;
    private List source;
    private Date refreshDate;
    private SortDefinition sort;
    private SortDefinition sortUsed;
    private int pageSize = 10;
    private int page = 0;
    private int maxLinkedPages = 10;

    public PagedListHolder() {
        this(new ArrayList(0));
    }

    public PagedListHolder(List source) {
        this.setSource(source);
        this.setSort(new MutableSortDefinition(true));
    }

    public void setSource(List source) {
        this.source = source;
        this.refreshDate = new Date();
        this.sortUsed = null;
    }

    public List getSource() {
        return this.source;
    }

    public Date getRefreshDate() {
        return this.refreshDate;
    }

    public void setSort(SortDefinition sort) {
        this.sort = sort;
    }

    public SortDefinition getSort() {
        return this.sort;
    }

    public void setPageSize(int pageSize) {
        if (pageSize != this.pageSize) {
            this.pageSize = pageSize;
            this.page = 0;
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPage(int page) {
        this.page = page >= this.getNrOfPages() ? this.getNrOfPages() - 1 : page;
    }

    public int getPage() {
        return this.page;
    }

    public void setMaxLinkedPages(int maxLinkedPages) {
        this.maxLinkedPages = maxLinkedPages;
    }

    public int getMaxLinkedPages() {
        return this.maxLinkedPages;
    }

    public int getNrOfPages() {
        float nrOfPages = (float)this.source.size() / (float)this.pageSize;
        return (int)(nrOfPages > (float)((int)nrOfPages) || (double)nrOfPages == 0.0 ? nrOfPages + 1.0f : nrOfPages);
    }

    public boolean isFirstPage() {
        return this.page == 0;
    }

    public boolean isLastPage() {
        return this.page == this.getNrOfPages() - 1;
    }

    public void previousPage() {
        if (!this.isFirstPage()) {
            --this.page;
        }
    }

    public void nextPage() {
        if (!this.isLastPage()) {
            ++this.page;
        }
    }

    public int getNrOfElements() {
        return this.source.size();
    }

    public int getFirstElementOnPage() {
        return this.pageSize * this.page;
    }

    public int getLastElementOnPage() {
        int endIndex = this.pageSize * (this.page + 1);
        return (endIndex > this.source.size() ? this.source.size() : endIndex) - 1;
    }

    public List getPageList() {
        return this.source.subList(this.getFirstElementOnPage(), this.getLastElementOnPage() + 1);
    }

    public int getFirstLinkedPage() {
        return Math.max(0, this.getPage() - this.maxLinkedPages / 2);
    }

    public int getLastLinkedPage() {
        return Math.min(this.getFirstLinkedPage() + this.maxLinkedPages - 1, this.getNrOfPages() - 1);
    }

    public void resort() {
        if (this.sort != null && !"".equals(this.sort.getProperty()) && !this.sort.equals(this.sortUsed)) {
            PropertyComparator.sort(this.source, this.sort);
            this.sortUsed = new MutableSortDefinition(this.sort);
            this.setPage(0);
        }
    }
}

