/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.InvalidTimeoutException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Constants;

public abstract class AbstractPlatformTransactionManager
implements PlatformTransactionManager {
    public static final int SYNCHRONIZATION_ALWAYS = 0;
    public static final int SYNCHRONIZATION_ON_ACTUAL_TRANSACTION = 1;
    public static final int SYNCHRONIZATION_NEVER = 2;
    private static final Constants constants = new Constants(class$org$springframework$transaction$support$AbstractPlatformTransactionManager == null ? (class$org$springframework$transaction$support$AbstractPlatformTransactionManager = AbstractPlatformTransactionManager.class$("org.springframework.transaction.support.AbstractPlatformTransactionManager")) : class$org$springframework$transaction$support$AbstractPlatformTransactionManager);
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int transactionSynchronization = 0;
    private boolean rollbackOnCommitFailure = false;
    static /* synthetic */ Class class$org$springframework$transaction$support$AbstractPlatformTransactionManager;

    public void setTransactionSynchronizationName(String constantName) {
        this.setTransactionSynchronization(constants.asNumber(constantName).intValue());
    }

    public void setTransactionSynchronization(int transactionSynchronization) {
        this.transactionSynchronization = transactionSynchronization;
    }

    public int getTransactionSynchronization() {
        return this.transactionSynchronization;
    }

    public void setRollbackOnCommitFailure(boolean rollbackOnCommitFailure) {
        this.rollbackOnCommitFailure = rollbackOnCommitFailure;
    }

    public boolean isRollbackOnCommitFailure() {
        return this.rollbackOnCommitFailure;
    }

    public TransactionStatus getTransaction(TransactionDefinition definition) throws TransactionException {
        Object transaction = this.doGetTransaction();
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (debugEnabled) {
            this.logger.debug((Object)("Using transaction object [" + transaction + "]"));
        }
        if (this.isExistingTransaction(transaction)) {
            if (debugEnabled) {
                this.logger.debug((Object)"Participating in existing transaction");
            }
            boolean newSynchronization = this.transactionSynchronization != 2;
            return this.newTransactionStatus(transaction, false, newSynchronization, debugEnabled);
        }
        if (definition == null) {
            definition = new DefaultTransactionDefinition();
        }
        if (definition.getTimeout() < -1) {
            throw new InvalidTimeoutException("Invalid transaction timeout", definition.getTimeout());
        }
        if (definition.getPropagationBehavior() == 2) {
            throw new NoTransactionException("Transaction propagation mandatory but no existing transaction context found");
        }
        if (definition.getPropagationBehavior() == 0) {
            if (debugEnabled) {
                this.logger.debug((Object)"Creating new transaction");
            }
            this.doBegin(transaction, definition);
            boolean newSynchronization = this.transactionSynchronization != 2;
            return this.newTransactionStatus(transaction, true, newSynchronization, debugEnabled);
        }
        boolean newSynchronization = this.transactionSynchronization == 0;
        return this.newTransactionStatus(null, false, newSynchronization, debugEnabled);
    }

    private TransactionStatus newTransactionStatus(Object transaction, boolean newTransaction, boolean newSynchronization, boolean debug) {
        boolean actualNewSynchronization;
        boolean bl = actualNewSynchronization = newSynchronization && !TransactionSynchronizationManager.isSynchronizationActive();
        if (actualNewSynchronization) {
            TransactionSynchronizationManager.initSynchronization();
        }
        return new TransactionStatus(transaction, newTransaction, actualNewSynchronization, debug);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(TransactionStatus status) throws TransactionException {
        block14: {
            if (status.isRollbackOnly() || status.getTransaction() != null && this.isRollbackOnly(status.getTransaction())) {
                if (status.isDebug()) {
                    this.logger.debug((Object)"Transactional code has requested rollback");
                }
                this.rollback(status);
                return;
            }
            try {
                try {
                    if (status.isNewSynchronization()) {
                        TransactionSynchronizationManager.triggerBeforeCommit();
                        TransactionSynchronizationManager.triggerBeforeCompletion();
                    }
                    if (status.isNewTransaction()) {
                        this.logger.info((Object)"Initiating transaction commit");
                        this.doCommit(status);
                    }
                    this.triggerAfterCompletion(status, 0, null);
                }
                catch (UnexpectedRollbackException ex) {
                    this.triggerAfterCompletion(status, 1, ex);
                    throw ex;
                }
                catch (TransactionException ex) {
                    if (this.rollbackOnCommitFailure) {
                        this.doRollbackOnCommitException(status, ex);
                        this.triggerAfterCompletion(status, 1, ex);
                        throw ex;
                    }
                    this.triggerAfterCompletion(status, 2, ex);
                    throw ex;
                }
                catch (RuntimeException ex) {
                    this.doRollbackOnCommitException(status, ex);
                    this.triggerAfterCompletion(status, 1, ex);
                    throw ex;
                }
                catch (Error err) {
                    this.doRollbackOnCommitException(status, err);
                    this.triggerAfterCompletion(status, 2, err);
                    throw err;
                }
                Object var4_2 = null;
                if (!status.isNewSynchronization()) break block14;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                if (status.isNewSynchronization()) {
                    TransactionSynchronizationManager.clearSynchronization();
                }
                if (!status.isNewTransaction()) throw throwable;
                this.cleanupAfterCompletion(status.getTransaction());
                throw throwable;
            }
            TransactionSynchronizationManager.clearSynchronization();
        }
        if (!status.isNewTransaction()) return;
        this.cleanupAfterCompletion(status.getTransaction());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback(TransactionStatus status) throws TransactionException {
        block12: {
            try {
                try {
                    if (status.isNewSynchronization()) {
                        TransactionSynchronizationManager.triggerBeforeCompletion();
                    }
                    if (status.isNewTransaction()) {
                        this.logger.info((Object)"Initiating transaction rollback");
                        this.doRollback(status);
                    } else if (status.getTransaction() != null) {
                        if (status.isDebug()) {
                            this.logger.debug((Object)"Setting existing transaction rollback-only");
                        }
                        this.doSetRollbackOnly(status);
                    } else {
                        this.logger.info((Object)"Should roll back transaction but cannot - no transaction available");
                    }
                    this.triggerAfterCompletion(status, 1, null);
                }
                catch (TransactionException ex) {
                    this.triggerAfterCompletion(status, 2, ex);
                    throw ex;
                }
                Object var4_2 = null;
                if (!status.isNewSynchronization()) break block12;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                if (status.isNewSynchronization()) {
                    TransactionSynchronizationManager.clearSynchronization();
                }
                if (!status.isNewTransaction()) throw throwable;
                this.cleanupAfterCompletion(status.getTransaction());
                throw throwable;
            }
            TransactionSynchronizationManager.clearSynchronization();
        }
        if (!status.isNewTransaction()) return;
        this.cleanupAfterCompletion(status.getTransaction());
    }

    private void doRollbackOnCommitException(TransactionStatus status, Throwable ex) throws TransactionException {
        try {
            if (status.isNewTransaction()) {
                if (status.isDebug()) {
                    this.logger.debug((Object)"Initiating transaction rollback on commit exception", ex);
                }
                this.doRollback(status);
            }
        }
        catch (TransactionException tex) {
            this.logger.error((Object)"Commit exception overridden by rollback exception", ex);
            throw tex;
        }
    }

    private void triggerAfterCompletion(TransactionStatus status, int completionStatus, Throwable ex) {
        if (status.isNewSynchronization()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Triggering afterCompletion synchronization");
            }
            try {
                TransactionSynchronizationManager.triggerAfterCompletion(completionStatus);
            }
            catch (RuntimeException tsex) {
                if (ex != null) {
                    this.logger.error((Object)"Rollback exception overridden by synchronization exception", ex);
                }
                throw tsex;
            }
            catch (Error tserr) {
                if (ex != null) {
                    this.logger.error((Object)"Rollback exception overridden by synchronization exception", ex);
                }
                throw tserr;
            }
        }
    }

    protected abstract Object doGetTransaction() throws TransactionException;

    protected abstract boolean isExistingTransaction(Object var1) throws TransactionException;

    protected abstract void doBegin(Object var1, TransactionDefinition var2) throws TransactionException;

    protected boolean isRollbackOnly(Object transaction) throws TransactionException {
        return false;
    }

    protected abstract void doCommit(TransactionStatus var1) throws TransactionException;

    protected abstract void doRollback(TransactionStatus var1) throws TransactionException;

    protected abstract void doSetRollbackOnly(TransactionStatus var1) throws TransactionException;

    protected void cleanupAfterCompletion(Object transaction) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

