/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.springframework.transaction.interceptor.AbstractTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeEditor;

public class NameMatchTransactionAttributeSource
extends AbstractTransactionAttributeSource {
    private Map nameMap = new HashMap();

    public void setNameMap(Map nameMap) {
        this.nameMap = nameMap;
    }

    public void setProperties(Properties transactionAttributes) {
        TransactionAttributeEditor tae = new TransactionAttributeEditor();
        Iterator<Object> it = transactionAttributes.keySet().iterator();
        while (it.hasNext()) {
            String methodName = (String)it.next();
            String value = transactionAttributes.getProperty(methodName);
            tae.setAsText(value);
            TransactionAttribute attr = (TransactionAttribute)tae.getValue();
            this.addTransactionalMethod(methodName, attr);
        }
    }

    public void addTransactionalMethod(String methodName, TransactionAttribute attr) {
        this.logger.debug((Object)("Adding transactional method [" + methodName + "] with attribute [" + attr + "]"));
        this.nameMap.put(methodName, attr);
    }

    public TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        String methodName = method.getName();
        TransactionAttribute attr = (TransactionAttribute)this.nameMap.get(methodName);
        if (attr != null) {
            return attr;
        }
        String bestNameMatch = null;
        Iterator it = this.nameMap.keySet().iterator();
        while (it.hasNext()) {
            String mappedName = (String)it.next();
            if (!this.isMatch(methodName, mappedName) || bestNameMatch != null && bestNameMatch.length() > mappedName.length()) continue;
            attr = (TransactionAttribute)this.nameMap.get(mappedName);
            bestNameMatch = mappedName;
        }
        return attr;
    }
}

