/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.jdo.JdoDialect;

public class JdoAccessor
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PersistenceManagerFactory persistenceManagerFactory;
    private JdoDialect jdoDialect;
    private boolean flushEager = false;

    public void setPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        this.persistenceManagerFactory = pmf;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    public void setJdoDialect(JdoDialect jdoDialect) {
        this.jdoDialect = jdoDialect;
    }

    public JdoDialect getJdoDialect() {
        return this.jdoDialect;
    }

    public void setFlushEager(boolean flushEager) {
        this.flushEager = flushEager;
    }

    public boolean isFlushEager() {
        return this.flushEager;
    }

    public void afterPropertiesSet() {
        if (this.persistenceManagerFactory == null) {
            throw new IllegalArgumentException("persistenceManagerFactory is required");
        }
        if (this.flushEager && this.jdoDialect == null) {
            throw new IllegalArgumentException("Cannot flush eagerly without a jdoDialect setting");
        }
    }

    protected void flushIfNecessary(PersistenceManager pm, boolean existingTransaction) throws JDOException {
        if (this.flushEager && this.jdoDialect != null) {
            this.logger.debug((Object)"Eagerly flushing JDO persistence manager");
            this.jdoDialect.flush(pm.currentTransaction());
        }
    }
}

