/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.ObjectDeletedException;
import net.sf.hibernate.ObjectNotFoundException;
import net.sf.hibernate.PersistentObjectException;
import net.sf.hibernate.Query;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.StaleObjectStateException;
import net.sf.hibernate.TransientObjectException;
import net.sf.hibernate.WrongClassException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate.HibernateJdbcException;
import org.springframework.orm.hibernate.HibernateObjectRetrievalFailureException;
import org.springframework.orm.hibernate.HibernateOptimisticLockingFailureException;
import org.springframework.orm.hibernate.HibernateQueryException;
import org.springframework.orm.hibernate.HibernateSystemException;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class SessionFactoryUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$orm$hibernate$SessionFactoryUtils == null ? (class$org$springframework$orm$hibernate$SessionFactoryUtils = SessionFactoryUtils.class$("org.springframework.orm.hibernate.SessionFactoryUtils")) : class$org$springframework$orm$hibernate$SessionFactoryUtils));
    static /* synthetic */ Class class$org$springframework$orm$hibernate$SessionFactoryUtils;

    public static Session getSession(SessionFactory sessionFactory, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        if (!TransactionSynchronizationManager.hasResource(sessionFactory) && !allowCreate) {
            throw new IllegalStateException("Not allowed to create new Hibernate session");
        }
        return SessionFactoryUtils.getSession(sessionFactory, null, null);
    }

    public static Session getSession(SessionFactory sessionFactory, Interceptor entityInterceptor, SQLExceptionTranslator jdbcExceptionTranslator) throws DataAccessResourceFailureException {
        SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.getResource(sessionFactory);
        if (holder != null) {
            return holder.getSession();
        }
        try {
            Session session;
            logger.debug((Object)"Opening Hibernate session");
            Session session2 = session = entityInterceptor != null ? sessionFactory.openSession(entityInterceptor) : sessionFactory.openSession();
            if (TransactionSynchronizationManager.isSynchronizationActive()) {
                logger.debug((Object)"Registering transaction synchronization for Hibernate session");
                TransactionSynchronizationManager.bindResource(sessionFactory, new SessionHolder(session));
                TransactionSynchronizationManager.registerSynchronization(new SessionSynchronization(session, sessionFactory, jdbcExceptionTranslator));
            }
            return session;
        }
        catch (JDBCException ex) {
            throw new DataAccessResourceFailureException("Cannot open Hibernate session", ex.getSQLException());
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Cannot open Hibernate session", ex);
        }
    }

    public static void applyTransactionTimeout(Query query, SessionFactory sessionFactory) {
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource(sessionFactory);
        if (sessionHolder != null && sessionHolder.getDeadline() != null) {
            query.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    public static DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCException) {
            return new HibernateJdbcException((JDBCException)((Object)ex));
        }
        if (ex instanceof ObjectNotFoundException) {
            return new HibernateObjectRetrievalFailureException((ObjectNotFoundException)ex);
        }
        if (ex instanceof ObjectDeletedException) {
            return new HibernateObjectRetrievalFailureException((ObjectDeletedException)ex);
        }
        if (ex instanceof WrongClassException) {
            return new HibernateObjectRetrievalFailureException((WrongClassException)ex);
        }
        if (ex instanceof StaleObjectStateException) {
            return new HibernateOptimisticLockingFailureException((StaleObjectStateException)ex);
        }
        if (ex instanceof QueryException) {
            return new HibernateQueryException((QueryException)ex);
        }
        if (ex instanceof PersistentObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage());
        }
        if (ex instanceof TransientObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage());
        }
        return new HibernateSystemException(ex);
    }

    public static void closeSessionIfNecessary(Session session, SessionFactory sessionFactory) throws CleanupFailureDataAccessException {
        if (session == null || TransactionSynchronizationManager.hasResource(sessionFactory)) {
            return;
        }
        logger.debug((Object)"Closing Hibernate session");
        try {
            session.close();
        }
        catch (JDBCException ex) {
            throw new CleanupFailureDataAccessException("Cannot close Hibernate session", ex.getSQLException());
        }
        catch (HibernateException ex) {
            throw new CleanupFailureDataAccessException("Cannot close Hibernate session", ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SessionSynchronization
    implements TransactionSynchronization {
        private Session session;
        private SessionFactory sessionFactory;
        private SQLExceptionTranslator jdbcExceptionTranslator;

        public SessionSynchronization(Session session, SessionFactory sessionFactory, SQLExceptionTranslator jdbcExceptionTranslator) {
            this.session = session;
            this.sessionFactory = sessionFactory;
            this.jdbcExceptionTranslator = jdbcExceptionTranslator;
        }

        public void beforeCommit() throws DataAccessException {
            if (!this.session.getFlushMode().equals(FlushMode.NEVER)) {
                logger.debug((Object)"Flushing Hibernate session on transaction synchronization");
                try {
                    this.session.flush();
                }
                catch (JDBCException ex) {
                    if (this.jdbcExceptionTranslator != null) {
                        throw this.jdbcExceptionTranslator.translate("SessionSynchronization", null, ex.getSQLException());
                    }
                    throw new HibernateJdbcException(ex);
                }
                catch (HibernateException ex) {
                    throw SessionFactoryUtils.convertHibernateAccessException(ex);
                }
            }
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) throws CleanupFailureDataAccessException {
            TransactionSynchronizationManager.unbindResource(this.sessionFactory);
            SessionFactoryUtils.closeSessionIfNecessary(this.session, this.sessionFactory);
        }
    }
}

