/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import net.sf.hibernate.FlushMode;
import org.springframework.orm.hibernate.SessionHolder;

public class HibernateTransactionObject {
    private SessionHolder sessionHolder;
    private boolean newSessionHolder;
    private Integer previousIsolationLevel;
    private FlushMode previousFlushMode;

    protected HibernateTransactionObject() {
    }

    protected HibernateTransactionObject(SessionHolder sessionHolder) {
        this.sessionHolder = sessionHolder;
        this.newSessionHolder = false;
    }

    protected void setSessionHolder(SessionHolder sessionHolder) {
        if (this.sessionHolder != null) {
            throw new IllegalStateException("Already initialized with an existing SessionHolder");
        }
        this.sessionHolder = sessionHolder;
        this.newSessionHolder = true;
    }

    public SessionHolder getSessionHolder() {
        return this.sessionHolder;
    }

    public boolean isNewSessionHolder() {
        return this.newSessionHolder;
    }

    public boolean hasTransaction() {
        return this.sessionHolder != null && this.sessionHolder.getTransaction() != null;
    }

    protected void setPreviousIsolationLevel(Integer previousIsolationLevel) {
        this.previousIsolationLevel = previousIsolationLevel;
    }

    public Integer getPreviousIsolationLevel() {
        return this.previousIsolationLevel;
    }

    protected void setPreviousFlushMode(FlushMode previousFlushMode) {
        this.previousFlushMode = previousFlushMode;
    }

    public FlushMode getPreviousFlushMode() {
        return this.previousFlushMode;
    }
}

