/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.SqlParameter;

public class PreparedStatementCreatorFactory {
    private List declaredParameters = new LinkedList();
    private String sql;
    private boolean updatableResults = false;

    public PreparedStatementCreatorFactory(String sql) {
        this(sql, new LinkedList());
    }

    public PreparedStatementCreatorFactory(String sql, int[] types) {
        this(sql, SqlParameter.sqlTypesToAnonymousParameterList(types));
    }

    public PreparedStatementCreatorFactory(String sql, List declaredParameters) {
        this(sql, declaredParameters, false);
    }

    public PreparedStatementCreatorFactory(String sql, int[] types, boolean updatableResults) {
        this(sql, SqlParameter.sqlTypesToAnonymousParameterList(types), updatableResults);
    }

    public PreparedStatementCreatorFactory(String sql, List declaredParameters, boolean updatableResults) {
        this.sql = sql;
        this.declaredParameters = declaredParameters;
        this.updatableResults = updatableResults;
    }

    public void addParameter(SqlParameter p) {
        this.declaredParameters.add(p);
    }

    public PreparedStatementCreator newPreparedStatementCreator(Object[] params) {
        return new PreparedStatementCreatorImpl(params != null ? Arrays.asList(params) : new LinkedList());
    }

    public PreparedStatementCreator newPreparedStatementCreator(List params) {
        return new PreparedStatementCreatorImpl(params != null ? params : new LinkedList());
    }

    private class PreparedStatementCreatorImpl
    implements PreparedStatementCreator {
        private List parameters;

        private PreparedStatementCreatorImpl(List params) {
            this.parameters = params;
            if (this.parameters.size() != PreparedStatementCreatorFactory.this.declaredParameters.size()) {
                throw new InvalidDataAccessApiUsageException("SQL='" + PreparedStatementCreatorFactory.this.sql + "': given " + this.parameters.size() + " parameter but expected " + PreparedStatementCreatorFactory.this.declaredParameters.size());
            }
        }

        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            PreparedStatement ps = null;
            ps = PreparedStatementCreatorFactory.this.updatableResults ? con.prepareStatement(PreparedStatementCreatorFactory.this.sql, 1003, 1008) : con.prepareStatement(PreparedStatementCreatorFactory.this.sql);
            block3: for (int i = 0; i < this.parameters.size(); ++i) {
                SqlParameter declaredParameter = (SqlParameter)PreparedStatementCreatorFactory.this.declaredParameters.get(i);
                if (this.parameters.get(i) == null) {
                    ps.setNull(i + 1, declaredParameter.getSqlType());
                    continue;
                }
                switch (declaredParameter.getSqlType()) {
                    case 12: {
                        ps.setString(i + 1, (String)this.parameters.get(i));
                        continue block3;
                    }
                    default: {
                        ps.setObject(i + 1, this.parameters.get(i), declaredParameter.getSqlType());
                    }
                }
            }
            return ps;
        }

        public String toString() {
            StringBuffer sbuf = new StringBuffer("PreparedStatementCreatorFactory.PreparedStatementCreatorImpl: sql={" + PreparedStatementCreatorFactory.this.sql + "}: params={");
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (i > 0) {
                    sbuf.append(",");
                }
                sbuf.append(this.parameters.get(i));
            }
            return sbuf.toString() + "}";
        }
    }
}

