/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;

public class CustomBooleanEditor
extends PropertyEditorSupport {
    private boolean allowEmpty;

    public CustomBooleanEditor(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allowEmpty && text.trim().equals("")) {
            this.setValue(null);
        } else if (text.equalsIgnoreCase("true")) {
            this.setValue(Boolean.TRUE);
        } else if (text.equalsIgnoreCase("false")) {
            this.setValue(Boolean.FALSE);
        } else {
            throw new IllegalArgumentException("Invalid Boolean value [" + text + "]");
        }
    }
}

