/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractVetoableChangeListener
implements VetoableChangeListener {
    private final Log logger = LogFactory.getLog(this.getClass());
    protected static final String VALIDATE_METHOD_PREFIX = "validate";
    private HashMap validationMethodHash = new HashMap();
    static /* synthetic */ Class class$java$beans$PropertyChangeEvent;
    static /* synthetic */ Class class$java$beans$PropertyVetoException;

    public AbstractVetoableChangeListener() throws SecurityException {
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getName().startsWith(VALIDATE_METHOD_PREFIX) && methods[i].getParameterTypes().length == 2 && (class$java$beans$PropertyChangeEvent == null ? AbstractVetoableChangeListener.class$("java.beans.PropertyChangeEvent") : class$java$beans$PropertyChangeEvent).isAssignableFrom(methods[i].getParameterTypes()[1])) {
                this.logger.debug((Object)("Found potential validator method [" + methods[i] + "]"));
                Class<?>[] exceptions = methods[i].getExceptionTypes();
                if (exceptions.length == 1 && (class$java$beans$PropertyVetoException == null ? AbstractVetoableChangeListener.class$("java.beans.PropertyVetoException") : class$java$beans$PropertyVetoException).isAssignableFrom(exceptions[0])) {
                    methods[i].setAccessible(true);
                    String propertyName = Introspector.decapitalize(methods[i].getName().substring(VALIDATE_METHOD_PREFIX.length()));
                    this.validationMethodHash.put(propertyName, methods[i]);
                    this.logger.debug((Object)(methods[i] + " is validator for property " + propertyName));
                    continue;
                }
                this.logger.debug((Object)"Invalid validator");
                continue;
            }
            this.logger.debug((Object)("Method [" + methods[i] + "] is not a validator"));
        }
    }

    public final void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        Method method;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("VetoableChangeEvent: old value=[" + e.getOldValue() + "] new value=[" + e.getNewValue() + "]"));
        }
        if ((method = (Method)this.validationMethodHash.get(e.getPropertyName())) != null) {
            try {
                this.logger.debug((Object)("Using validator method: " + method));
                Object val = e.getNewValue();
                method.invoke((Object)this, val, e);
            }
            catch (IllegalAccessException ex) {
                this.logger.warn((Object)"Can't validate: Method isn't accessible");
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)ex.getTargetException();
                }
                PropertyVetoException pex = (PropertyVetoException)ex.getTargetException();
                throw pex;
            }
        } else {
            this.logger.debug((Object)("No validation method for property: " + e.getPropertyName()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

