/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.tags.HtmlEscapingAwareTag;
import org.springframework.web.util.ExpressionEvaluationUtils;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.TagUtils;

public class MessageTag
extends HtmlEscapingAwareTag {
    private String code;
    private String arguments;
    private String text;
    private String var;
    private String scope = "page";

    public void setCode(String code) {
        this.code = code;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    protected final int doStartTagInternal() throws JspException, IOException {
        MessageSource messageSource = this.getMessageSource();
        if (messageSource == null) {
            throw new JspTagException("No corresponding MessageSource found");
        }
        String resolvedCode = ExpressionEvaluationUtils.evaluateString((String)"code", (String)this.code, (PageContext)this.pageContext);
        String resolvedText = ExpressionEvaluationUtils.evaluateString((String)"text", (String)this.text, (PageContext)this.pageContext);
        String resolvedVar = ExpressionEvaluationUtils.evaluateString((String)"var", (String)this.var, (PageContext)this.pageContext);
        try {
            String msg = null;
            if (resolvedCode != null) {
                String resolvedArguments = ExpressionEvaluationUtils.evaluateString((String)"arguments", (String)this.arguments, (PageContext)this.pageContext);
                Object[] argumentsArray = StringUtils.commaDelimitedListToStringArray((String)resolvedArguments);
                msg = resolvedText != null ? messageSource.getMessage(resolvedCode, argumentsArray, resolvedText, this.getRequestContext().getLocale()) : messageSource.getMessage(resolvedCode, argumentsArray, this.getRequestContext().getLocale());
            } else {
                msg = resolvedText;
            }
            String string = msg = this.isHtmlEscape() ? HtmlUtils.htmlEscape((String)msg) : msg;
            if (resolvedVar != null) {
                String resolvedScope = ExpressionEvaluationUtils.evaluateString((String)"scope", (String)this.scope, (PageContext)this.pageContext);
                this.pageContext.setAttribute(resolvedVar, (Object)msg, TagUtils.getScope((String)resolvedScope));
            } else {
                this.writeMessage(msg);
            }
        }
        catch (NoSuchMessageException ex) {
            throw new JspTagException(this.getNoSuchMessageExceptionDescription(ex));
        }
        return 1;
    }

    protected void writeMessage(String msg) throws IOException {
        this.pageContext.getOut().write(msg);
    }

    protected MessageSource getMessageSource() {
        return this.getRequestContext().getWebApplicationContext();
    }

    protected String getNoSuchMessageExceptionDescription(NoSuchMessageException ex) {
        return ex.getMessage();
    }
}

