/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.util.StringUtils;

class ServletConfigPropertyValues
extends MutablePropertyValues {
    public ServletConfigPropertyValues(ServletConfig config) throws ServletException {
        this(config, null);
    }

    public ServletConfigPropertyValues(ServletConfig config, String[] requiredProperties) throws ServletException {
        List<String> missingProps = requiredProperties != null ? Arrays.asList(requiredProperties) : null;
        Enumeration enumeration = config.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String property = (String)enumeration.nextElement();
            String value = config.getInitParameter(property);
            this.addPropertyValue(new PropertyValue(property, (Object)value));
            if (missingProps == null) continue;
            missingProps.remove(property);
        }
        if (missingProps != null && missingProps.size() > 0) {
            throw new ServletException("Initialization from ServletConfig for servlet '" + config.getServletName() + "' failed; the following required properties were missing: " + StringUtils.collectionToDelimitedString(missingProps, (String)", "));
        }
    }
}

