/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.ServletRequestBindingException;

public abstract class RequestUtils {
    private static final IntParser INT_PARSER = new IntParser();
    private static final LongParser LONG_PARSER = new LongParser();
    private static final FloatParser FLOAT_PARSER = new FloatParser();
    private static final DoubleParser DOUBLE_PARSER = new DoubleParser();
    private static final BooleanParser BOOLEAN_PARSER = new BooleanParser();
    private static final StringParser STRING_PARSER = new StringParser();

    public static void rejectRequestMethod(HttpServletRequest request, String method) throws ServletException {
        if (request.getMethod().equals(method)) {
            throw new ServletException("This resource does not support request method '" + method + "'");
        }
    }

    public static int getIntParameter(HttpServletRequest request, String name, int defaultVal) {
        try {
            return RequestUtils.getRequiredIntParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static int[] getIntParameters(HttpServletRequest request, String name) {
        try {
            return RequestUtils.getRequiredIntParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new int[0];
        }
    }

    public static int getRequiredIntParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return INT_PARSER.parseInt(name, request.getParameter(name));
    }

    public static int[] getRequiredIntParameters(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return INT_PARSER.parseInts(name, request.getParameterValues(name));
    }

    public static long getLongParameter(HttpServletRequest request, String name, long defaultVal) {
        try {
            return RequestUtils.getRequiredLongParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static long[] getLongParameters(HttpServletRequest request, String name) {
        try {
            return RequestUtils.getRequiredLongParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new long[0];
        }
    }

    public static long getRequiredLongParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return LONG_PARSER.parseLong(name, request.getParameter(name));
    }

    public static long[] getRequiredLongParameters(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return LONG_PARSER.parseLongs(name, request.getParameterValues(name));
    }

    public static float getFloatParameter(HttpServletRequest request, String name, float defaultVal) {
        try {
            return RequestUtils.getRequiredFloatParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static float[] getFloatParameters(HttpServletRequest request, String name) {
        try {
            return RequestUtils.getRequiredFloatParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new float[0];
        }
    }

    public static float getRequiredFloatParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return FLOAT_PARSER.parseFloat(name, request.getParameter(name));
    }

    public static float[] getRequiredFloatParameters(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return FLOAT_PARSER.parseFloats(name, request.getParameterValues(name));
    }

    public static double getDoubleParameter(HttpServletRequest request, String name, double defaultVal) {
        try {
            return RequestUtils.getRequiredDoubleParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static double[] getDoubleParameters(HttpServletRequest request, String name) {
        try {
            return RequestUtils.getRequiredDoubleParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new double[0];
        }
    }

    public static double getRequiredDoubleParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return DOUBLE_PARSER.parseDouble(name, request.getParameter(name));
    }

    public static double[] getRequiredDoubleParameters(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return DOUBLE_PARSER.parseDoubles(name, request.getParameterValues(name));
    }

    public static boolean getBooleanParameter(HttpServletRequest request, String name, boolean defaultVal) {
        try {
            return RequestUtils.getRequiredBooleanParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static boolean[] getBooleanParameters(HttpServletRequest request, String name) {
        try {
            return RequestUtils.getRequiredBooleanParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new boolean[0];
        }
    }

    public static boolean getRequiredBooleanParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return BOOLEAN_PARSER.parseBoolean(name, request.getParameter(name));
    }

    public static boolean[] getRequiredBooleanParameters(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return BOOLEAN_PARSER.parseBooleans(name, request.getParameterValues(name));
    }

    public static String getStringParameter(HttpServletRequest request, String name, String defaultVal) {
        try {
            return RequestUtils.getRequiredStringParameter(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return defaultVal;
        }
    }

    public static String[] getStringParameters(HttpServletRequest request, String name) {
        try {
            return RequestUtils.getRequiredStringParameters(request, name);
        }
        catch (ServletRequestBindingException ex) {
            return new String[0];
        }
    }

    public static String getRequiredStringParameter(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return STRING_PARSER.validateRequiredString(name, request.getParameter(name));
    }

    public static String[] getRequiredStringParameters(HttpServletRequest request, String name) throws ServletRequestBindingException {
        return STRING_PARSER.validateRequiredStrings(name, request.getParameterValues(name));
    }

    private static class StringParser
    extends ParameterParser {
        private StringParser() {
        }

        protected String getType() {
            return "string";
        }

        protected Object doParse(String parameter) throws NumberFormatException {
            return parameter;
        }

        public String validateRequiredString(String name, String value) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, value);
            return value;
        }

        public String[] validateRequiredStrings(String name, String[] values) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, values);
            for (int i = 0; i < values.length; ++i) {
                this.validateRequiredParameter(name, values[i]);
            }
            return values;
        }
    }

    private static class BooleanParser
    extends ParameterParser {
        private BooleanParser() {
        }

        protected String getType() {
            return "boolean";
        }

        protected Object doParse(String parameter) throws NumberFormatException {
            return new Boolean(parameter.equalsIgnoreCase("true") || parameter.equalsIgnoreCase("yes") || parameter.equalsIgnoreCase("on") || parameter.equals("1"));
        }

        public boolean parseBoolean(String name, String parameter) throws ServletRequestBindingException {
            return (Boolean)this.parse(name, parameter);
        }

        public boolean[] parseBooleans(String name, String[] values) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, values);
            boolean[] parameters = new boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseBoolean(name, values[i]);
            }
            return parameters;
        }
    }

    private static class DoubleParser
    extends ParameterParser {
        private DoubleParser() {
        }

        protected String getType() {
            return "double";
        }

        protected Object doParse(String parameter) throws NumberFormatException {
            return Double.valueOf(parameter);
        }

        public double parseDouble(String name, String parameter) throws ServletRequestBindingException {
            return ((Number)this.parse(name, parameter)).doubleValue();
        }

        public double[] parseDoubles(String name, String[] values) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, values);
            double[] parameters = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseDouble(name, values[i]);
            }
            return parameters;
        }
    }

    private static class FloatParser
    extends ParameterParser {
        private FloatParser() {
        }

        protected String getType() {
            return "float";
        }

        protected Object doParse(String parameter) throws NumberFormatException {
            return Float.valueOf(parameter);
        }

        public float parseFloat(String name, String parameter) throws ServletRequestBindingException {
            return ((Number)this.parse(name, parameter)).floatValue();
        }

        public float[] parseFloats(String name, String[] values) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, values);
            float[] parameters = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseFloat(name, values[i]);
            }
            return parameters;
        }
    }

    private static class LongParser
    extends ParameterParser {
        private LongParser() {
        }

        protected String getType() {
            return "long";
        }

        protected Object doParse(String parameter) throws NumberFormatException {
            return Long.valueOf(parameter);
        }

        public long parseLong(String name, String parameter) throws ServletRequestBindingException {
            return ((Number)this.parse(name, parameter)).longValue();
        }

        public long[] parseLongs(String name, String[] values) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, values);
            long[] parameters = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseLong(name, values[i]);
            }
            return parameters;
        }
    }

    private static class IntParser
    extends ParameterParser {
        private IntParser() {
        }

        protected String getType() {
            return "int";
        }

        protected Object doParse(String s) throws NumberFormatException {
            return Integer.valueOf(s);
        }

        public int parseInt(String name, String parameter) throws ServletRequestBindingException {
            return ((Number)this.parse(name, parameter)).intValue();
        }

        public int[] parseInts(String name, String[] values) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, values);
            int[] parameters = new int[values.length];
            for (int i = 0; i < values.length; ++i) {
                parameters[i] = this.parseInt(name, values[i]);
            }
            return parameters;
        }
    }

    private static abstract class ParameterParser {
        private ParameterParser() {
        }

        protected final Object parse(String name, String parameter) throws ServletRequestBindingException {
            this.validateRequiredParameter(name, parameter);
            try {
                return this.doParse(parameter);
            }
            catch (NumberFormatException ex) {
                throw new ServletRequestBindingException("Required " + this.getType() + " parameter '" + name + "' with value of '" + parameter + "' is not a valid number");
            }
        }

        protected final void validateRequiredParameter(String name, Object parameter) throws ServletRequestBindingException {
            if (parameter == null) {
                throw new ServletRequestBindingException("Required " + this.getType() + " parameter '" + name + "' is not present");
            }
            if ("".equals(parameter)) {
                throw new ServletRequestBindingException("Required " + this.getType() + " parameter '" + name + "' contains no value");
            }
        }

        protected abstract String getType();

        protected abstract Object doParse(String var1) throws NumberFormatException;
    }
}

