/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import javax.servlet.ServletRequest;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.validation.DataBinder;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestParameterPropertyValues;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class ServletRequestDataBinder
extends DataBinder {
    public ServletRequestDataBinder(Object target, String name) {
        super(target, name);
    }

    public void bind(ServletRequest request) {
        this.bind(new ServletRequestParameterPropertyValues(request));
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            this.bind((PropertyValues)new MutablePropertyValues(multipartRequest.getFileMap()));
        }
    }

    public void closeNoCatch() throws ServletRequestBindingException {
        if (this.getErrors().hasErrors()) {
            throw new ServletRequestBindingException("Errors binding onto object '" + this.getErrors().getObjectName() + "'", (Throwable)this.getErrors());
        }
    }
}

