/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ojb;

import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.ojb.PersistenceBrokerHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class OjbFactoryUtils {
    public static PersistenceBroker getPersistenceBroker(PBKey pbKey, boolean allowCreate) throws DataAccessResourceFailureException, IllegalStateException {
        return OjbFactoryUtils.getPersistenceBroker(pbKey, allowCreate, true);
    }

    public static PersistenceBroker getPersistenceBroker(PBKey pbKey, boolean allowCreate, boolean allowSynchronization) throws DataAccessResourceFailureException, IllegalStateException {
        PersistenceBrokerHolder pbHolder = (PersistenceBrokerHolder)((Object)TransactionSynchronizationManager.getResource((Object)pbKey));
        if (pbHolder != null) {
            return pbHolder.getPersistenceBroker();
        }
        if (!allowCreate) {
            throw new IllegalStateException("No OJB persistence broker bound to thread, and configuration does not allow creation of new one here");
        }
        try {
            PersistenceBroker pb = PersistenceBrokerFactory.createPersistenceBroker((PBKey)pbKey);
            if (allowSynchronization && TransactionSynchronizationManager.isSynchronizationActive()) {
                pbHolder = new PersistenceBrokerHolder(pb);
                TransactionSynchronizationManager.bindResource((Object)pbKey, (Object)((Object)pbHolder));
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new PersistenceBrokerSynchronization(pbHolder, pbKey));
            }
            return pb;
        }
        catch (OJBRuntimeException ex) {
            throw new DataAccessResourceFailureException("Could not open OJB persistence broker", (Throwable)ex);
        }
    }

    public static void closePersistenceBrokerIfNecessary(PersistenceBroker pb, PBKey pbKey) {
        if (pb == null || TransactionSynchronizationManager.hasResource((Object)pbKey)) {
            return;
        }
        pb.close();
    }

    private static class PersistenceBrokerSynchronization
    extends TransactionSynchronizationAdapter {
        private final PersistenceBrokerHolder persistenceBrokerHolder;
        private final PBKey pbKey;

        private PersistenceBrokerSynchronization(PersistenceBrokerHolder pbHolder, PBKey pbKey) {
            this.persistenceBrokerHolder = pbHolder;
            this.pbKey = pbKey;
        }

        public void suspend() {
            TransactionSynchronizationManager.unbindResource((Object)this.pbKey);
        }

        public void resume() {
            TransactionSynchronizationManager.bindResource((Object)this.pbKey, (Object)((Object)this.persistenceBrokerHolder));
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource((Object)this.pbKey);
            OjbFactoryUtils.closePersistenceBrokerIfNecessary(this.persistenceBrokerHolder.getPersistenceBroker(), this.pbKey);
        }
    }
}

