/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo.support;

import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.orm.jdo.PersistenceManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class OpenPersistenceManagerInViewInterceptor
extends HandlerInterceptorAdapter {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private PersistenceManagerFactory persistenceManagerFactory;

    public void setPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        this.persistenceManagerFactory = pmf;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws DataAccessException {
        this.logger.debug((Object)"Opening JDO persistence manager in OpenPersistenceManagerInViewInterceptor");
        PersistenceManager pm = PersistenceManagerFactoryUtils.getPersistenceManager(this.getPersistenceManagerFactory(), true);
        TransactionSynchronizationManager.bindResource((Object)this.getPersistenceManagerFactory(), (Object)((Object)new PersistenceManagerHolder(pm)));
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws DataAccessException {
        PersistenceManagerHolder pmHolder = (PersistenceManagerHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.getPersistenceManagerFactory()));
        this.logger.debug((Object)"Closing JDO persistence manager in OpenPersistenceManagerInViewInterceptor");
        PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(pmHolder.getPersistenceManager(), this.getPersistenceManagerFactory());
    }
}

