/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.TransactionException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.CleanupFailureDataAccessException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.orm.hibernate.HibernateJdbcException;
import org.springframework.orm.hibernate.HibernateTransactionObject;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean {
    private SessionFactory sessionFactory;
    private DataSource dataSource;
    private Interceptor entityInterceptor;
    private SQLExceptionTranslator jdbcExceptionTranslator = new SQLStateSQLExceptionTranslator();

    public HibernateTransactionManager() {
    }

    public HibernateTransactionManager(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.afterPropertiesSet();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setEntityInterceptor(Interceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    public Interceptor getEntityInterceptor() {
        return this.entityInterceptor;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        return this.jdbcExceptionTranslator;
    }

    public void afterPropertiesSet() {
        if (this.sessionFactory == null) {
            throw new IllegalArgumentException("sessionFactory is required");
        }
    }

    protected Object doGetTransaction() {
        if (TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
            SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.sessionFactory));
            this.logger.debug((Object)("Found thread-bound session [" + sessionHolder.getSession() + "] for Hibernate transaction"));
            return new HibernateTransactionObject(sessionHolder);
        }
        return new HibernateTransactionObject();
    }

    protected boolean isExistingTransaction(Object transaction) {
        return ((HibernateTransactionObject)transaction).hasTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        Session session;
        HibernateTransactionObject txObject = (HibernateTransactionObject)transaction;
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (txObject.getSessionHolder() == null) {
            session = SessionFactoryUtils.getSession(this.sessionFactory, this.entityInterceptor, this.jdbcExceptionTranslator, false);
            if (debugEnabled) {
                this.logger.debug((Object)("Opened new session [" + session + "] for Hibernate transaction"));
            }
            txObject.setSessionHolder(new SessionHolder(session));
        }
        try {
            FlushMode flushMode;
            Connection con;
            session = txObject.getSessionHolder().getSession();
            if (debugEnabled) {
                this.logger.debug((Object)("Beginning Hibernate transaction on session [" + session + "]"));
            }
            if (definition.isReadOnly()) {
                if (txObject.isNewSessionHolder()) {
                    session.setFlushMode(FlushMode.NEVER);
                }
                try {
                    con = session.connection();
                    if (debugEnabled) {
                        this.logger.debug((Object)("Setting JDBC connection [" + con + "] read-only"));
                    }
                    con.setReadOnly(true);
                }
                catch (Exception ex) {
                    this.logger.warn((Object)"Could not set JDBC connection read-only", (Throwable)ex);
                }
            } else if (!txObject.isNewSessionHolder() && FlushMode.NEVER.equals(flushMode = session.getFlushMode())) {
                txObject.setPreviousFlushMode(flushMode);
                session.setFlushMode(FlushMode.AUTO);
            }
            if (definition.getIsolationLevel() != -1) {
                con = session.connection();
                if (debugEnabled) {
                    this.logger.debug((Object)("Changing isolation level of JDBC connection [" + con + "] to " + definition.getIsolationLevel()));
                }
                txObject.setPreviousIsolationLevel(new Integer(con.getTransactionIsolation()));
                session.connection().setTransactionIsolation(definition.getIsolationLevel());
            }
            txObject.getSessionHolder().setTransaction(session.beginTransaction());
            if (definition.getTimeout() != -1) {
                txObject.getSessionHolder().setTimeoutInSeconds(definition.getTimeout());
            }
            if (txObject.isNewSessionHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)txObject.getSessionHolder()));
            }
            if (this.dataSource != null) {
                ConnectionHolder conHolder = new ConnectionHolder(session.connection());
                if (definition.getTimeout() != -1) {
                    conHolder.setTimeoutInSeconds(definition.getTimeout());
                }
                TransactionSynchronizationManager.bindResource((Object)this.dataSource, (Object)conHolder);
            }
        }
        catch (SQLException ex) {
            throw new CannotCreateTransactionException("Could not set transaction isolation", (Throwable)ex);
        }
        catch (HibernateException ex) {
            throw new CannotCreateTransactionException("Could not create Hibernate transaction", (Throwable)ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)transaction;
        txObject.setSessionHolder(null);
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory));
        ConnectionHolder connectionHolder = null;
        if (this.dataSource != null) {
            connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResource((Object)this.dataSource);
        }
        return new SuspendedResourcesHolder(sessionHolder, connectionHolder);
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        SuspendedResourcesHolder resourcesHolder = (SuspendedResourcesHolder)suspendedResources;
        if (TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        }
        TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)resourcesHolder.getSessionHolder()));
        if (this.dataSource != null) {
            TransactionSynchronizationManager.bindResource((Object)this.dataSource, (Object)resourcesHolder.getConnectionHolder());
        }
    }

    protected boolean isRollbackOnly(Object transaction) {
        return ((HibernateTransactionObject)transaction).getSessionHolder().isRollbackOnly();
    }

    protected void doCommit(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing Hibernate transaction on session [" + txObject.getSessionHolder().getSession() + "]"));
        }
        try {
            txObject.getSessionHolder().getTransaction().commit();
        }
        catch (TransactionException ex) {
            throw new TransactionSystemException("Could not commit Hibernate transaction", (Throwable)ex);
        }
        catch (JDBCException ex) {
            throw this.convertJdbcAccessException(ex.getSQLException());
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back Hibernate transaction on session [" + txObject.getSessionHolder().getSession() + "]"));
        }
        try {
            txObject.getSessionHolder().getTransaction().rollback();
        }
        catch (TransactionException ex) {
            throw new TransactionSystemException("Could not rollback Hibernate transaction", (Throwable)ex);
        }
        catch (JDBCException ex) {
            throw this.convertJdbcAccessException(ex.getSQLException());
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Setting Hibernate transaction on Session [" + txObject.getSessionHolder().getSession() + "] rollback-only"));
        }
        txObject.getSessionHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        HibernateTransactionObject txObject = (HibernateTransactionObject)transaction;
        if (this.dataSource != null) {
            TransactionSynchronizationManager.unbindResource((Object)this.dataSource);
        }
        if (txObject.isNewSessionHolder()) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        }
        try {
            Connection con = txObject.getSessionHolder().getSession().connection();
            if (txObject.getPreviousIsolationLevel() != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Resetting isolation level of connection [" + con + "] to " + txObject.getPreviousIsolationLevel()));
                }
                con.setTransactionIsolation(txObject.getPreviousIsolationLevel());
            }
            if (con.isReadOnly()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Resetting read-only flag of connection [" + con + "]"));
                }
                con.setReadOnly(false);
            }
        }
        catch (Exception ex) {
            this.logger.info((Object)"Could not reset JDBC connection of Hibernate session", (Throwable)ex);
        }
        Session session = txObject.getSessionHolder().getSession();
        if (txObject.isNewSessionHolder()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing Hibernate session [" + session + "] after transaction"));
            }
            try {
                SessionFactoryUtils.closeSessionIfNecessary(session, this.sessionFactory);
            }
            catch (CleanupFailureDataAccessException ex) {
                this.logger.error((Object)"Count not close Hibernate session after transaction", (Throwable)ex);
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Not closing pre-bound Hibernate session [" + session + "] after transaction"));
            }
            txObject.getSessionHolder().setTransaction(null);
            if (txObject.getPreviousFlushMode() != null) {
                session.setFlushMode(txObject.getPreviousFlushMode());
            }
        }
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        return SessionFactoryUtils.convertHibernateAccessException(ex);
    }

    protected DataAccessException convertJdbcAccessException(SQLException ex) {
        if (this.jdbcExceptionTranslator != null) {
            return this.jdbcExceptionTranslator.translate("HibernateTemplate", null, ex);
        }
        return new HibernateJdbcException(ex);
    }

    private static class SuspendedResourcesHolder {
        private final SessionHolder sessionHolder;
        private final ConnectionHolder connectionHolder;

        private SuspendedResourcesHolder(SessionHolder sessionHolder, ConnectionHolder connectionHolder) {
            this.sessionHolder = sessionHolder;
            this.connectionHolder = connectionHolder;
        }

        private SessionHolder getSessionHolder() {
            return this.sessionHolder;
        }

        private ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }
    }
}

