/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import org.springframework.test.AbstractDependencyInjectionSpringContextTests;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public abstract class AbstractTransactionalSpringContextTests
extends AbstractDependencyInjectionSpringContextTests {
    private boolean complete;
    protected TransactionStatus transactionStatus;
    protected PlatformTransactionManager transactionManager;
    private boolean defaultRollback = true;

    public void setDefaultRollback(boolean defaultRollback) {
        this.defaultRollback = defaultRollback;
    }

    public void setTransactionManager(PlatformTransactionManager ptm) {
        this.transactionManager = ptm;
    }

    protected final void onSetUp() throws Exception {
        this.complete = !this.defaultRollback;
        this.transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        this.logger.info((Object)("Began transaction: transaction manager=[" + this.transactionManager + "]; defaultCommit=" + this.complete));
        this.onSetUpInTransaction();
    }

    protected void onSetUpInTransaction() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void onTearDown() throws Exception {
        block3: {
            try {
                this.onTearDownInTransaction();
                Object var2_1 = null;
                if (this.complete) break block3;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (!this.complete) {
                    this.transactionManager.rollback(this.transactionStatus);
                    this.logger.info((Object)"Rolled back transaction after test execution");
                    throw throwable;
                }
                this.transactionManager.commit(this.transactionStatus);
                this.logger.info((Object)"Committed transaction after test execution");
                throw throwable;
            }
            this.transactionManager.rollback(this.transactionStatus);
            this.logger.info((Object)"Rolled back transaction after test execution");
            return;
        }
        this.transactionManager.commit(this.transactionStatus);
        this.logger.info((Object)"Committed transaction after test execution");
    }

    protected void onTearDownInTransaction() {
    }

    protected void setComplete() {
        this.complete = true;
    }
}

