/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.support;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.PropertiesBeanDefinitionReader;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class JdbcBeanDefinitionReader {
    private PropertiesBeanDefinitionReader propReader;
    private JdbcTemplate jdbcTemplate;

    public JdbcBeanDefinitionReader(DefaultListableBeanFactory beanFactory) {
        this.propReader = new PropertiesBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
    }

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void loadBeanDefinitions(String sql) {
        final Properties props = new Properties();
        this.jdbcTemplate.query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                String beanName = rs.getString(1);
                String property = rs.getString(2);
                String value = rs.getString(3);
                props.setProperty(beanName + "." + property, value);
            }
        });
        this.propReader.registerBeanDefinitions((Map)props);
    }
}

